% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_gettitleitems.R
\name{bhl_gettitleitems}
\alias{bhl_gettitleitems}
\title{Return a list of a title's items (books).}
\usage{
bhl_gettitleitems(titleid, as = "table", key = NULL, ...)
}
\arguments{
\item{titleid}{the identifier of an individual title (numeric)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a list of a title's items (books).
}
\examples{
\dontrun{
bhl_gettitleitems(1726)
bhl_gettitleitems(1726, as='xml')
bhl_gettitleitems(1726, as='list')
}
}

