% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height_shade.R
\name{height_shade}
\alias{height_shade}
\title{Calculate Terrain Color Map}
\usage{
height_shade(heightmap, texture = grDevices::terrain.colors(256))
}
\arguments{
\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point.}

\item{texture}{Default `terrain.colors(256)`. A color palette for the plot.}
}
\value{
RGB array of hillshaded texture mappings.
}
\description{
Calculates a color for each point on the surface using a direct elevation-to-color mapping.
}
\examples{
#Create a direct mapping of elevation to color:
montereybay \%>\%
 height_shade() \%>\%
 plot_map()
 
#Add a shadow:
\donttest{
montereybay \%>\%
 height_shade() \%>\%
 add_shadow(ray_shade(montereybay,zscale=50),0.3) \%>\%
 plot_map()
}

#Change the palette:
\donttest{
montereybay \%>\%
 height_shade(texture = topo.colors(256)) \%>\%
 add_shadow(ray_shade(montereybay,zscale=50),0.3) \%>\%
 plot_map()
}

#Really change the palette:
\donttest{
montereybay \%>\%
 height_shade(texture = rainbow(256)) \%>\%
 add_shadow(ray_shade(montereybay,zscale=50),0.3) \%>\%
 plot_map()
}
}
