% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.R
\name{diffuse}
\alias{diffuse}
\title{Diffuse Material}
\usage{
diffuse(
  color = "#ffffff",
  checkercolor = NA,
  checkerperiod = 3,
  noise = 0,
  noisephase = 0,
  noiseintensity = 10,
  noisecolor = "#000000",
  gradient_color = NA,
  gradient_transpose = FALSE,
  image_array = NA,
  fog = FALSE,
  fogdensity = 0.01,
  sigma = NULL,
  importance_sample = FALSE
)
}
\arguments{
\item{color}{Default `white`. The color of the surface. Can be either
a hexadecimal code, R color string, or a numeric rgb vector listing three intensities between `0` and `1`.}

\item{checkercolor}{Default `NA`. If not `NA`, determines the secondary color of the checkered surface. 
Can be either a hexadecimal code, or a numeric rgb vector listing three intensities between `0` and `1`.}

\item{checkerperiod}{Default `3`. The period of the checker pattern. Increasing this value makes the checker 
pattern bigger, and decreasing it makes it smaller}

\item{noise}{Default `0`. If not `0`, covers the surface in a turbulent marble pattern. This value will determine
the amount of turbulence in the texture.}

\item{noisephase}{Default `0`. The phase of the noise. The noise will repeat at `360`.}

\item{noiseintensity}{Default `10`. Intensity of the noise.}

\item{noisecolor}{Default `#000000`. The secondary color of the noise pattern.
Can be either a hexadecimal code, or a numeric rgb vector listing three intensities between `0` and `1`.}

\item{gradient_color}{Default `NA`. If not `NA`, creates a secondary color for a linear gradient 
between the this color and color specified in `color`. Direction is determined by `gradient_transpose`.}

\item{gradient_transpose}{Default `FALSE`. If `TRUE`, this will use the `v` coordinate texture instead
of the `u` coordinate texture to map the gradient.}

\item{image_array}{A 3-layer RGB array to be used as the texture on the surface of the object.}

\item{fog}{Default `FALSE`. If `TRUE`, the object will be a volumetric scatterer.}

\item{fogdensity}{Default `0.01`. The density of the fog. Higher values will produce more opaque objects.}

\item{sigma}{Default `NULL`. A number between 0 and Infinity specifying the roughness of the surface using the Oren-Nayar microfacet model.
Higher numbers indicate a roughed surface, where sigma is the standard deviation of the microfacet orientation angle. When 0, this reverts
to the default lambertian behavior.}

\item{importance_sample}{Default `FALSE`. If `TRUE`, the object will be sampled explicitly during 
the rendering process. If the object is particularly important in contributing to the light paths
in the image (e.g. light sources, refracting glass ball with caustics, metal objects concentrating light),
this will help with the convergence of the image.}
}
\value{
Single row of a tibble describing the diffuse material.
}
\description{
Diffuse Material
}
\examples{
#Generate the cornell box and add a single white sphere to the center
scene = generate_cornell() \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/8,material=diffuse()))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Add a checkered rectangular cube below             
scene = scene \%>\%
  add_object(cube(x=555/2,y=555/8,z=555/2,xwidth=555/2,ywidth=555/4,zwidth=555/2,
  material = diffuse(checkercolor="purple",checkerperiod=20)))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
  
#Add a marbled sphere           
scene = scene \%>\%
  add_object(sphere(x=555/2+555/4,y=555/2,z=555/2,radius=555/8,
  material = diffuse(noise=1/20)))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Add an orange volumetric (fog) cube           
scene = scene \%>\%
  add_object(cube(x=555/2-555/4,y=555/2,z=555/2,xwidth=555/4,ywidth=555/4,zwidth=555/4,
  material = diffuse(fog=TRUE, fogdensity=0.05,color="orange")))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#' #Add an line segment with a color gradient        
scene = scene \%>\%
  add_object(segment(start = c(555,450,450),end=c(0,450,450),radius = 50, 
                     material = diffuse(color="#1f7326", gradient_color = "#a60d0d")))
\donttest{
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=500,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
}
