% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_bw.R
\name{render_bw}
\alias{render_bw}
\title{Render Black and White}
\usage{
render_bw(
  image,
  rgb_coef = c(0.2126, 0.7152, 0.0722),
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename, 3-layer RGB array, or matrix.}

\item{rgb_coef}{Default \code{c(0.2126, 0.7152, 0.0722)}.
Length-3 numeric vector listing coefficients to convert RGB to luminance.}

\item{filename}{Default \code{NULL}. The filename of the image to be saved. If this is not given, the image will be plotted instead.}

\item{preview}{Default \code{FALSE}. Whether to plot the convolved image, or just to return the values.}
}
\value{
3-layer RGB resized array or matrix.
}
\description{
Transforms an image to black and white, preserving luminance.
}
\examples{
if(run_documentation()){
#Plot the image with a title
dragon |>
 add_title("Dragon", title_offset=c(10,10), title_bar_color="black",
           title_size=20, title_color = "white") |>
 render_bw(preview = TRUE)
}
}
