% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaggle.R
\name{kaggle}
\alias{kaggle}
\title{Retrieve raw R code from a kaggle notebook}
\usage{
kaggle(url, method, padding)
}
\arguments{
\item{url}{Link to a kaggle notebook}

\item{method}{Not all websites are formatted consistently. To overcome this, try a different
method by setting the method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1 containing the R code from the target url. Returned value
   will contain rmarkdown or python code if that was the language used in the kaggle notebook.
}
\description{
Retrieve raw R code from a kaggle notebook
}
\examples{
\donttest{
library(dplyr)
kaggle("https://www.kaggle.com/vrtjso/mercari-eda-more-info-than-you-can-imagine")
kaggle("https://www.kaggle.com/captcalculator/a-very-extensive-mercari-exploratory-analysis")
kaggle("https://www.kaggle.com/adityaecdrid/mnist-with-keras-for-beginners-99457")

# Same as above but provided to cat for easy viewing

# R
kaggle("https://www.kaggle.com/vrtjso/mercari-eda-more-info-than-you-can-imagine")  \%>\%
  cat

# rmarkdown
kaggle("https://www.kaggle.com/captcalculator/a-very-extensive-mercari-exploratory-analysis") \%>\%
  cat

# python
kaggle("https://www.kaggle.com/adityaecdrid/mnist-with-keras-for-beginners-99457") \%>\%
  cat
}
}
