% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger}
\alias{logger}
\alias{set_logger_path}
\alias{logger_threshold}
\alias{logger_error_condition}
\alias{error_notification}
\alias{with_error_notification}
\title{Logger system used by 'RAVE'}
\usage{
logger(
  ...,
  level = c("info", "warning", "error", "fatal", "debug", "trace"),
  calc_delta = "auto",
  .envir = parent.frame(),
  .sep = "",
  use_glue = FALSE,
  reset_timer = FALSE
)

set_logger_path(root_path, max_bytes, max_files)

logger_threshold(
  level = c("info", "warning", "error", "fatal", "debug", "trace"),
  module_id,
  type = c("console", "file", "both")
)

logger_error_condition(cond, level = "error")

error_notification(
  cond,
  title = "Error found!",
  type = "danger",
  class = "error_notif",
  delay = 30000,
  autohide = TRUE,
  session = shiny::getDefaultReactiveDomain()
)

with_error_notification(expr, envir = parent.frame(), quoted = FALSE, ...)
}
\arguments{
\item{..., .envir, .sep}{passed to \code{\link[raveio]{glue}}, if
\code{use_glue} is true}

\item{level}{the level of message, choices are \code{'info'} (default),
\code{'warning'}, \code{'error'}, \code{'fatal'}, \code{'debug'},
\code{'trace'}}

\item{calc_delta}{whether to calculate time difference between current
message and previous message; default is \code{'auto'}, which prints
time difference when \code{level} is \code{'debug'}.
This behavior can be changed by altering \code{calc_delta} by a logical
\code{TRUE} to enable or \code{FALSE} to disable.}

\item{use_glue}{whether to use \code{\link[raveio]{glue}} to combine
\code{...}; default is false}

\item{reset_timer}{whether to reset timer used by \code{calc_delta}}

\item{root_path}{root directory if you want log messages to be saved to
hard disks; if \code{root_path} is \code{NULL}, \code{""}, or
\code{\link{nullfile}}, then logger path will be unset.}

\item{max_bytes}{maximum file size for each logger partitions}

\item{max_files}{maximum number of partition files to hold the log; old
files will be deleted.}

\item{module_id}{'RAVE' module identification string, or name-space; default
is \code{'ravedash'}}

\item{type}{which type of logging should be set; default is \code{'console'},
if file log is enabled through \code{set_logger_path}, \code{type} could be
\code{'file'} or \code{'both'}. Default log level is \code{'info'} on
console and \code{'debug'} on file.}

\item{cond}{condition to log}

\item{class, title, delay, autohide}{passed to \code{\link[shidashi]{show_notification}}}

\item{session}{shiny session}

\item{expr}{expression to evaluate}

\item{envir}{environment to evaluate \code{expr}}

\item{quoted}{whether \code{expr} is quoted; default is false}
}
\value{
The message without time-stamps
}
\description{
Keep track of messages printed by modules
}
\examples{
logger("This is a message")

a <- 1
logger("A message with glue: a={a}")

logger("A message without glue: a={a}", use_glue = FALSE)


logger("Message A", calc_delta = TRUE, reset_timer = TRUE)
logger("Seconds before logging another message", calc_delta = TRUE)


# by default, debug and trace messages won't be displayed
logger('debug message', level = 'debug')

# adjust logger level, make sure `module_id` is a valid RAVE module ID
logger_threshold('debug', module_id = NULL)

# Debug message will display
logger('debug message', level = 'debug')

# Trace message will not display as it's lower than debug level
logger('trace message', level = 'trace')

}
