% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-app.R
\name{rave-session}
\alias{rave-session}
\alias{new_session}
\alias{use_session}
\alias{launch_session}
\alias{remove_session}
\alias{remove_all_sessions}
\alias{list_session}
\title{Create, register, list, and remove 'RAVE' sessions}
\usage{
new_session(update = FALSE)

use_session(x)

launch_session(
  x,
  host = "127.0.0.1",
  port = NULL,
  options = list(jupyter = TRUE, jupyter_port = NULL, as_job = TRUE, launch_browser =
    TRUE)
)

remove_session(x)

remove_all_sessions()

list_session(path = session_root())
}
\arguments{
\item{update}{logical, whether to update to latest 'RAVE' template}

\item{x}{session identification string, or session object; use
\code{list_session} to list all existing sessions}

\item{host, port, options}{configurations needed to launch the session}

\item{path}{root path to store the sessions; default is the
\code{"tensor_temp_path"} in \code{\link[raveio]{raveio_getopt}}}
}
\value{
\describe{
\item{\code{new_session}}{returns a session object with character
\code{'session_id'} and a function \code{'launch_session'} to launch the
application from this session}
\item{\code{use_session}}{returns a session object, the same as
\code{new_session} under the condition that corresponding session exists,
or raise an error if the session is missing}
\item{\code{list_session}}{returns a list of all existing session objects
under the session root}
\item{\code{remove_session}}{returns a logical whether the corresponding
session has been found and removed}
}
}
\description{
Create, register, list, and remove 'RAVE' sessions
}
\examples{

if(interactive()){

  sess <- new_session()
  sess$launch_session()

  all_sessions <- list_session()
  print(all_sessions)

  # Use existing session
  session_id <- all_sessions[[1]]$session_id
  sess <- use_session(session_id)
  sess$launch_session()

  # Remove session
  remove_session(session_id)
  list_session()
}

}
