% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moverci.R
\name{jeffreysci}
\alias{jeffreysci}
\title{Jeffreys and other approximate Bayesian confidence intervals for a single 
binomial or Poisson rate.}
\usage{
jeffreysci(x, n, ai = 0.5, bi = 0.5, cc = 0, level = 0.95,
  distrib = "bin", adj = TRUE, ...)
}
\arguments{
\item{x}{Numeric vector of number of events.}

\item{n}{Numeric vector of sample sizes (for binomial rates) or exposure 
times (for Poisson rates).}

\item{ai, bi}{Numbers defining the Beta prior distribution (default ai = bi =
0.5 for Jeffreys interval). Gamma prior for Poisson rates requires only ai.}

\item{cc}{Number or logical specifying (amount of) "continuity correction". 
cc = 0 (default) gives Jeffreys interval, cc = 0.5 gives the
Clopper-Pearson interval. A value between 0 and 0.5 allows a compromise
between proximate and conservative coverage.}

\item{level}{Number specifying confidence level (between 0 and 1, default
0.95).}

\item{distrib}{Character string indicating distribution assumed for the input
data: "bin" = binomial (default), "poi" = Poisson.}

\item{adj}{Logical (default TRUE) indicating whether to apply the boundary 
adjustment recommended on p108 of Brown et al. (set to FALSE if informative
priors are used)}

\item{...}{Other arguments.}
}
\description{
Generalised approximate Bayesian confidence intervals based on a Beta (for 
binomial rates) or Gamma (for Poisson rates) conjugate priors. Encompassing 
the Jeffreys method (with Beta(0.5, 0.5) or Gamma(0.5) respectively), as well
as any user-specified prior distribution. Clopper-Pearson also included by 
way of a "continuity correction".
}
\examples{
  #Jeffreys method:
  jeffreysci(x = 5, n = 56)
}
\author{
Pete Laud, \email{p.j.laud@sheffield.ac.uk}
}

