% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterize_points.R
\name{rasterize_points}
\alias{rasterize_points}
\title{rasterize_points}
\usage{
rasterize_points(
  rastObj,
  data = NULL,
  mapping = aes(),
  ...,
  xlim = NULL,
  ylim = NULL,
  max_size = NULL,
  reduction_func = NULL,
  layout = NULL,
  glyph = NULL,
  group_by_data_table = NULL,
  inherit.aes = TRUE
)
}
\arguments{
\item{rastObj}{A \code{rasterly} object.}

\item{data}{A \code{data.frame} or \code{function} with an argument \code{x}, specifying the dataset to use for plotting. If \code{data} 
is \code{NULL}, the \code{data} argument provided to \code{rasterly} may be passed through.}

\item{mapping}{Default list of aesthetic mappings to use for plot. If provided and \code{inherit.aes = TRUE}, it will be
stacked on top of the mappings passed to \code{rasterly}.}

\item{...}{Pass-through arguments provided by \code{rasterly}.}

\item{xlim}{Vector of type numeric. X limits in this layer.}

\item{ylim}{Vector of type numeric. Y limits in this layer.}

\item{max_size}{Numeric. When size changes, the upper bound of the number of pixels over which to spread a single observation.}

\item{reduction_func}{Function. A reduction function is used to aggregate data points into their pixel representations. Currently
supported reduction operators are \code{sum}, \code{any}, \code{mean}, \code{m2}, \code{first}, \code{last}, \code{min} and \code{max}. Default is \code{sum}. See details.}

\item{layout}{Character. The method used to generate layouts for multiple images. The default is \code{weighted}. Useful for categorical
data (i.e. "color" is provided via \code{aes()}). \code{weighted} specifies that the final raster should be a weighted combination of each
(categorical) aggregation matrix. Conversely, \code{cover} indicates that the afterwards objects will be drawn on top of 
the previous ones.}

\item{glyph}{Character. Currently, only "circle" and "square" are supported; as the \code{size} of the pixels increases, how should they
spread out -- should the pattern be circular or square? Other glyphs may be added in the future.}

\item{group_by_data_table}{Logical. Default is \code{TRUE}; when "color" is provided via \code{aes()}, the "group by" operation may be
perfromed within \code{data.table} or natively within \code{rasterly}. Generally, \code{group_by_data_table = TRUE} is faster, but for very
large datasets grouping within \code{rasterly} may offer better performance.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than combining with them.}
}
\description{
Points layer for "rasterly". Deprecated now, please use \code{rasterly_points} instead.
}
\seealso{
\link{rasterly_points}
}
