% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{openCluster}
\alias{openCluster}
\title{Open a Parallel Cluster}
\usage{
openCluster(cluster.type = "SOCK", np = 2, progBar = TRUE, debugging = FALSE)
}
\arguments{
\item{cluster.type}{A character string specifying the type of cluster.
Accepted values are "SOCK", "FORK", or "MPI".}

\item{np}{An integer specifying the number of processes to be used in the parallel cluster.}

\item{progBar}{logical. If TRUE a progress bar is shown.}

\item{debugging}{logical. For developer use.}
}
\value{
An object representing the parallel cluster.
}
\description{
Opens a parallel cluster for computation, registers it for parallel operations,
and ensures its closure on script exit.
}
\examples{
\dontrun{
  # Open a SOCK cluster with 4 cores
  cls <- openCluster("SOCK", 4)
  # Your parallel computation code here
  # The cluster will automatically close when the script exits
}

}
