% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tes.R
\name{tes}
\alias{tes}
\title{Calculation of Total Expected Species base on ESa, ESb and their average value}
\usage{
tes(x, knots = 40)
}
\arguments{
\item{x}{a data vector representing number of individuals for each species}

\item{knots}{specifies the number of separate sample sizes of increasing value used for the calculation of ES between 1 and the endpoint, which by default is set to knots=40}
}
\value{
a list, which contains a table of the summary of the estimated values and their standard deviations based on TESa, TESb, and TESab, and the model used in the estimation of TES, either 'logistic' or 'Weibull'
}
\description{
Calculation of Total Expected Species base on ESa, ESb and their average value
}
\examples{
data(share, package = 'rarestR')
Output_tes <- tes(share[1,])
Output_tes
}
