% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapData.R, R/RapSolved.R
\name{spp.subset}
\alias{spp.subset}
\alias{spp.subset.RapData}
\alias{spp.subset.RapUnsolOrSol}
\title{Subset species}
\usage{
spp.subset(x, species)

\method{spp.subset}{RapData}(x, species)

\method{spp.subset}{RapUnsolOrSol}(x, species)
}
\arguments{
\item{x}{\code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}}, or
\code{\link[=RapSolved]{RapSolved()}} object.}

\item{species}{\code{integer}, or \code{character} vectors to specify the
index or species names to subset.}
}
\value{
\code{\link[=RapData]{RapData()}} or \code{\link[=RapUnsolved]{RapUnsolved()}} object depending
on input object.
}
\description{
Subset species from a \code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}}, or
\code{\link[=RapSolved]{RapSolved()}} object.
}
\examples{
\dontrun{
# load data
data(sim_ru)

# generate new object with only species 1
sim_ru2 <- spp.subset(sim_ru, 1)
}
}
\seealso{
\code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}},
\code{\link[=RapSolved]{RapSolved()}}.
}
