% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{set_parameter_value}
\alias{set_parameter_value}
\title{Set a parameter with a new value}
\usage{
set_parameter_value(l, parameter, value)
}
\arguments{
\item{l}{the list of apsimx file}

\item{parameter}{the name of parameter with APSIM NG specification}

\item{value}{the new value}
}
\value{
A list with replaced value
}
\description{
Set a parameter with a new value
}
\examples{
 wheat <- read_apsimx(system.file("Wheat.json", package = "rapsimng"))
 new_wheat <- set_parameter_value(wheat,
  "[Structure].BranchingRate.PotentialBranchingRate.Reproductive.Zero.FixedValue",
  1)
new_wheat2 <- search_path(new_wheat,
    "[Structure].BranchingRate.PotentialBranchingRate.Reproductive.Zero")
new_wheat2$node$FixedValue

new_wheat <- set_parameter_value(
    wheat,
    "[Structure].HeightModel.WaterStress.XYPairs.Y",
    "0.1,1.1")
new_wheat2 <- search_path(new_wheat,
    "[Structure].HeightModel.WaterStress.XYPairs")
new_wheat2$node$Y
}
