/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.langdetect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.langdetect.LanguageDetectorEvaluationErrorListener;
import opennlp.tools.cmdline.langdetect.LanguageDetectorFineGrainedReportListener;
import opennlp.tools.cmdline.langdetect.LanguageDetectorModelLoader;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageDetectorEvaluator;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.ObjectStream;

public final class LanguageDetectorEvaluatorTool
extends AbstractEvaluatorTool<LanguageSample, EvalToolParams> {
    public LanguageDetectorEvaluatorTool() {
        super(LanguageSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Language Detector model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        LanguageDetectorModel model = (LanguageDetectorModel)new LanguageDetectorModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<LanguageDetectorEvaluationMonitor> listeners = new LinkedList<LanguageDetectorEvaluationMonitor>();
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new LanguageDetectorEvaluationErrorListener());
        }
        LanguageDetectorFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new LanguageDetectorFineGrainedReportListener(reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating LanguageDetector fine-grained report file: " + e.getMessage());
            }
        }
        LanguageDetectorEvaluator evaluator = new LanguageDetectorEvaluator(new LanguageDetectorME(model), listeners.toArray(new LanguageDetectorEvaluationMonitor[listeners.size()]));
        final PerformanceMonitor monitor = new PerformanceMonitor("doc");
        ObjectStream<LanguageSample> measuredSampleStream = new ObjectStream<LanguageSample>(){

            @Override
            public LanguageSample read() throws IOException {
                monitor.incrementCounter();
                return (LanguageSample)LanguageDetectorEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                LanguageDetectorEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                LanguageDetectorEvaluatorTool.this.sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        System.out.println(evaluator);
        if (reportListener != null) {
            System.out.println("Writing fine-grained report to " + ((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
    }
}

