% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moduleStats.R
\name{stats}
\alias{stats}
\alias{statsInput}
\alias{statsUI}
\alias{statsServer}
\alias{statsApp}
\alias{logFormat}
\alias{logTimeFrame}
\title{Shiny modules and helper functions for registry usage reports}
\usage{
statsInput(id)

statsUI(id)

statsServer(id, registryName, eligible = TRUE)

statsApp()

logFormat(log)

logTimeFrame(log, startDate, endDate)
}
\arguments{
\item{id}{Character string shiny module id}

\item{registryName}{Character string registry name key}

\item{eligible}{Logical defining if the module should be allowed to work at
full capacity. This might be useful when access to module products should be
restricted. Default is TRUE, \emph{i.e.} no restrictions.}

\item{log}{Data frame containing log data (in Rapporteket format)}

\item{startDate}{Date object defining start of interval (character
representation "YYYY-MM-DD")}

\item{endDate}{Date object defining end of interval (character representation
"YYYY-MM-DD")}
}
\value{
Shiny objects, mostly. Helper functions may return other stuff too.
}
\description{
These modules may be used by registries for easy setup of usage reports.
The intended purpose is to provide registry staff access to when and by
whom the resources at Rapporteket were used, \emph{i.e.} application
start-up and single report usage. As such, this will be a tool to provide
useful statistics. However, it might also serve as a formal monitor utility
but only if logging is carefully implemented throughout the relevant
functions that make up the registry application at Rapporteket.
}
\examples{
# client user interface function
ui <- shiny::fluidPage(
  shiny::sidebarLayout(
    shiny::sidebarPanel(statsInput("test")),
    shiny::mainPanel(statsUI("test"))
  )
)

# server function
server <- function(input, output, session) {
  statsServer("test", registryName = "rapbase", eligible = TRUE)
}

# run the shiny app in an interactive environment
if (interactive()) {
  shiny::shinyApp(ui, server)
}
}
