% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ranger}
\alias{predict.ranger}
\title{Ranger prediction}
\usage{
\method{predict}{ranger}(object, data, predict.all = FALSE,
  num.trees = object$num.trees, type = "response", seed = NULL,
  num.threads = NULL, verbose = TRUE, ...)
}
\arguments{
\item{object}{Ranger \code{ranger} object.}

\item{data}{New test data of class \code{data.frame} or \code{gwaa.data} (GenABEL).}

\item{predict.all}{Return individual predictions for each tree instead of aggregated predictions for all trees. Return a matrix (sample x tree) for classification and regression, a 3d array for probability estimation (sample x class x tree) and survival (sample x time x tree).}

\item{num.trees}{Number of trees used for prediction. The first \code{num.trees} in the forest are used.}

\item{type}{Type of prediction. One of 'response' or 'terminalNodes' with default 'response'. See below for details.}

\item{seed}{Random seed used in Ranger.}

\item{num.threads}{Number of threads. Default is number of CPUs available.}

\item{verbose}{Verbose output on or off.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Object of class \code{ranger.prediction} with elements
  \tabular{ll}{
      \code{predictions}    \tab Predicted classes/values (only for classification and regression)  \cr
      \code{unique.death.times} \tab Unique death times (only for survival). \cr
      \code{chf} \tab Estimated cumulative hazard function for each sample (only for survival). \cr
      \code{survival} \tab Estimated survival function for each sample (only for survival). \cr
      \code{num.trees}   \tab Number of trees. \cr
      \code{num.independent.variables} \tab Number of independent variables. \cr
      \code{treetype}    \tab Type of forest/tree. Classification, regression or survival. \cr
      \code{num.samples}     \tab Number of samples.
  }
}
\description{
Prediction with new data and a saved forest from Ranger.
}
\details{
For \code{type = 'response'} (the default), the predicted classes (classification), predicted numeric values (regression), predicted probabilities (probability estimation) or survival probabilities (survival) are returned. 
For \code{type = 'terminalNodes'}, the IDs of the terminal node in each tree for each observation in the given dataset are returned.

For classification and \code{predict.all = TRUE}, a factor levels are returned as numerics.
To retrieve the corresponding factor levels, use \code{rf$forest$levels}, if \code{rf} is the ranger object.
}
\author{
Marvin N. Wright
}
\seealso{
\code{\link{ranger}}
}

