% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randStr.r
\name{randStr}
\alias{randStr}
\title{Generate random strings of a dictated size of symbol set and distribution of the lengths of strings.
The output is a list of 2 items: [[1]]vector of strings, [[2]]vector of the corresponding symbol set}
\usage{
randStr(nString, maxLen, minLen, stdevLen = 0, distLen = "normal",
  symbolSetSize, delimiter = "-")
}
\arguments{
\item{nString}{Number of strings to be generated}

\item{maxLen}{Maximum allowable length of the strings}

\item{minLen}{Minimum allowable length of the strings}

\item{stdevLen}{Standard deviation of the length of the strings, applicable if using truncated normal distribution for the lengths of strings i.e. distLen='normal'}

\item{distLen}{Distribution of the lengths of strings, can take on value of 'normal' or 'uniform'}

\item{symbolSetSize}{Allowable number of different symbols to appear in the strings}

\item{delimiter}{symbol separating each item in the strings}
}
\description{
Generate random strings of a dictated size of symbol set and distribution of the lengths of strings.
The output is a list of 2 items: [[1]]vector of strings, [[2]]vector of the corresponding symbol set
}
\examples{
randStr(nString = 10, maxLen = 30, minLen = 1, stdevLen = 15, symbolSetSize = 25)
}

