% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strata_rs_probabilities.R
\name{strata_rs_probabilities}
\alias{strata_rs_probabilities}
\title{Inclusion Probabilities: Stratified Random Sampling}
\usage{
strata_rs_probabilities(strata_var, prob = NULL, strata_n = NULL,
  strata_prob = NULL, check_inputs = TRUE)
}
\arguments{
\item{strata_var}{A vector of length N that indicates which stratum each unit belongs to. Can be a character, factor, or numeric vector. (required)}

\item{prob}{Use for a design in which either floor(N_stratum*prob) or ceiling(N_stratum*prob) units are assigned to treatment within each stratum. The probability of assignment to treatment is exactly prob because with probability 1-prob, floor(N_stratum*prob) units will be assigned to treatment and with probability prob, ceiling(N_stratum*prob) units will be assigned to treatment. prob must be a real number between 0 and 1 inclusive. (optional)}

\item{strata_n}{Use for a in which strata_n describes the number of units to assign to treatment within each stratum.}

\item{strata_prob}{Use for a in which strata_prob describes the probability of assignment to treatment within each stratum. Differs from prob in that the probability of assignment can vary across strata.}

\item{check_inputs}{logical. Defaults to TRUE.}
}
\value{
A vector length N indicating the probability of being sampled.
}
\description{
Inclusion Probabilities: Stratified Random Sampling
}
\examples{

strata_var <- rep(c("A", "B","C"), times = c(50, 100, 200))
probs <- strata_rs_probabilities(strata_var = strata_var)
table(strata_var, probs)

probs <- strata_rs_probabilities(strata_var = strata_var, prob = .2)
table(strata_var, probs)

probs <- strata_rs_probabilities(strata_var = strata_var, strata_prob = c(.1, .2, .3))
table(strata_var, probs)

probs <- strata_rs_probabilities(strata_var = strata_var, strata_n = c(10, 40, 70))
table(strata_var, probs)

}
