% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/randomizr.r
\name{block_ra}
\alias{block_ra}
\title{Block Random Assignment}
\usage{
block_ra(block_var, num_arms = NULL, block_m = NULL, block_prob = NULL,
  condition_names = NULL)
}
\arguments{
\item{block_var}{A vector of length N that includes the blocking variable}

\item{num_arms}{the total number of treatment arms. If unspecified, will be determined from the number of columns of block_m or the length of condition_names.}

\item{block_m}{A matrix whose number of rows is equal to the number of blocks and whose number of columns is equal to the number of treatment arms. The rows should respect the alphabetical ordering of the blocks as determined by sort(unique(block_var). The columns should be in the order of condition_names, if specified.}

\item{block_prob}{A vector whose length is equal to the number of treatment assignments. When specified, block_prob assigns the same (within rounding) proportion of each block to each treatment condition, using complete random assignment. block_prob must sum to 1.}

\item{condition_names}{a character vector giving the names of the treatment groups.  If unspecified, the treatment groups will be names T1, T2, T3, etc.}
}
\description{
This function assigns a fixed number of units within each block to treatment.
}
\examples{
block_var <- rep(c("A", "B","C"), times=c(50, 100, 200))
Z <- block_ra(block_var=block_var)
table(block_var, Z)

block_m <- rbind(c(25, 25),
                 c(50, 50),
                 c(100, 100))

Z <- block_ra(block_var=block_var, block_m=block_m)
table(block_var, Z)

block_m <- rbind(c(10, 40),
                 c(30, 70),
                 c(50, 150))

Z <- block_ra(block_var=block_var, block_m=block_m,
              condition_names=c("control", "treatment"))
table(block_var, Z)

# Multi-arm Designs
Z <- block_ra(block_var=block_var, num_arms=3)
table(block_var, Z)

block_m <- rbind(c(10, 20, 20),
                 c(30, 50, 20),
                 c(50, 75, 75))
Z <- block_ra(block_var=block_var, block_m=block_m )
table(block_var, Z)

Z <- block_ra(block_var=block_var, block_m=block_m,
              condition_names=c("control", "placebo", "treatment"))
table(block_var, Z)

Z <- block_ra(block_var=block_var, block_prob=c(.1, .1, .8))
table(block_var, Z)
}
\keyword{assignment}
\keyword{random}

