## ----eval=F--------------------------------------------------------------
#  install.packages("randomizeR")

## ----message=F-----------------------------------------------------------
library(randomizeR)

## ----cor-guess-----------------------------------------------------------
cg <- corGuess("CS")
cg

## ----further, eval=FALSE-------------------------------------------------
#  ?issues

## ----rar-----------------------------------------------------------------
rar <- rarPar(24)
rar

## ----pbr-----------------------------------------------------------------
bc <- rep(4, 24/4)
pbr <- pbrPar(bc)
pbr

## ----bsd-----------------------------------------------------------------
bsd <- bsdPar(24, 2)
bsd

## ----ra, eval=FALSE------------------------------------------------------
#  ?randPar

## ----sequences, results=F------------------------------------------------
rarS <- genSeq(rar,1000)
pbrS <- genSeq(pbr,1000)
bsdS <- genSeq(bsd,1000)

## ------------------------------------------------------------------------
bsdS

## ----results='hide'------------------------------------------------------
getRandList(bsdS)

## ------------------------------------------------------------------------
C <- compare(cg, rarS, pbrS, bsdS)
C

## ----plot-comp,eval=F----------------------------------------------------
#  plot(C)

## ----echo=F--------------------------------------------------------------
plot(C)

