/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.inference;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.datastream.DataSequence;
import eu.amidst.dynamic.inference.InferenceAlgorithmForDBN;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.variables.DynamicAssignment;
import java.util.stream.Stream;

public final class InferenceEngineForDBN {
    private static InferenceAlgorithmForDBN inferenceAlgorithmForDBN;

    public static void setInferenceAlgorithmForDBN(InferenceAlgorithmForDBN inferenceAlgorithmForDBN) {
        InferenceEngineForDBN.inferenceAlgorithmForDBN = inferenceAlgorithmForDBN;
    }

    public static void reset() {
        inferenceAlgorithmForDBN.reset();
    }

    public static void runInference() {
        inferenceAlgorithmForDBN.runInference();
    }

    public static void setModel(DynamicBayesianNetwork model) {
        inferenceAlgorithmForDBN.setModel(model);
    }

    public static DynamicBayesianNetwork getModel() {
        return inferenceAlgorithmForDBN.getOriginalModel();
    }

    public static void addDynamicEvidence(DynamicAssignment assignment) {
        inferenceAlgorithmForDBN.addDynamicEvidence(assignment);
    }

    public static <E extends UnivariateDistribution> E getFilteredPosterior(Variable var) {
        return inferenceAlgorithmForDBN.getFilteredPosterior(var);
    }

    public static <E extends UnivariateDistribution> E getPredictivePosterior(Variable var, int nTimesAhead) {
        return inferenceAlgorithmForDBN.getPredictivePosterior(var, nTimesAhead);
    }

    public static <E extends UnivariateDistribution> Stream<E> getStreamOfFilteredPosteriors(DataSequence dataSequence, Variable var) {
        return dataSequence.stream().map(data -> {
            inferenceAlgorithmForDBN.addDynamicEvidence((DynamicAssignment)data);
            inferenceAlgorithmForDBN.runInference();
            return inferenceAlgorithmForDBN.getFilteredPosterior(var);
        });
    }

    public static <E extends UnivariateDistribution> Stream<E> getStreamOfPredictivePosteriors(DataSequence dataSequence, Variable var, int nTimesAhead) {
        return dataSequence.stream().map(data -> {
            inferenceAlgorithmForDBN.addDynamicEvidence((DynamicAssignment)data);
            inferenceAlgorithmForDBN.runInference();
            return inferenceAlgorithmForDBN.getPredictivePosterior(var, nTimesAhead);
        });
    }

    public static <E extends UnivariateDistribution> E getLastFilteredPosteriorInTheSequence(DataSequence dataSequence, Variable var) {
        UnivariateDistribution[] dist = new UnivariateDistribution[1];
        InferenceEngineForDBN.getStreamOfFilteredPosteriors(dataSequence, var).forEach(e -> {
            dist[0] = e;
        });
        return (E)dist[0];
    }

    public static <E extends UnivariateDistribution> E getLastPredictivePosteriorInTheSequence(DataSequence dataSequence, Variable var, int nTimesAhead) {
        UnivariateDistribution[] dist = new UnivariateDistribution[1];
        InferenceEngineForDBN.getStreamOfPredictivePosteriors(dataSequence, var, nTimesAhead).forEach(e -> {
            dist[0] = e;
        });
        return (E)dist[0];
    }
}

