/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.inference;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.ConditionalLinearGaussian;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.Multinomial;
import eu.amidst.core.distribution.Multinomial_MultinomialParents;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.Normal_MultinomialNormalParents;
import eu.amidst.core.distribution.Normal_MultinomialParents;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.inference.ImportanceSamplingRobust;
import eu.amidst.core.inference.InferenceAlgorithm;
import eu.amidst.core.inference.messagepassing.MessagePassingAlgorithm;
import eu.amidst.core.inference.messagepassing.VMP;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.utils.Serialization;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.HashMapAssignment;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.VariableBuilder;
import eu.amidst.core.variables.Variables;
import eu.amidst.dynamic.inference.InferenceAlgorithmForDBN;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.models.DynamicDAG;
import eu.amidst.dynamic.utils.DynamicBayesianNetworkGenerator;
import eu.amidst.dynamic.utils.DynamicToStaticBNConverter;
import eu.amidst.dynamic.variables.DynamicAssignment;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class DynamicMAPInference
implements InferenceAlgorithmForDBN {
    private DynamicBayesianNetwork model;
    private BayesianNetwork unfoldedStaticModel;
    private List<BayesianNetwork> mergedClassVarModels;
    private int nTimeSteps = 2;
    private int nMergedClassVars = 2;
    private int sampleSize = 1000;
    private Variable MAPvariable;
    private String MAPvarName;
    private List<DynamicAssignment> evidence;
    private Assignment staticEvidence;
    private boolean parallelMode = true;
    private int seed = 125123;
    private Assignment MAPestimate;
    private int[] MAPsequence;
    private double MAPestimateLogProbability;
    String groupedClassName = "__GROUPED_CLASS__";
    private List<int[]> bestSequenceEachModel;
    List<List<UnivariateDistribution>> allGroupedPosteriorDistributions;
    List<UnivariateDistribution> allUngroupedPosteriorDistributions;

    @Override
    public void addDynamicEvidence(DynamicAssignment assignment) {
        throw new UnsupportedOperationException("Operation not supported in Dynamic MAP Inference");
    }

    @Override
    public void reset() {
        this.seed = 125123;
        this.parallelMode = true;
        this.sampleSize = 1000;
        this.nMergedClassVars = 2;
        this.nTimeSteps = 2;
        this.model = null;
        this.unfoldedStaticModel = null;
        this.mergedClassVarModels = null;
        this.evidence = null;
        this.MAPvarName = null;
        this.MAPvariable = null;
        this.MAPestimate = null;
        this.MAPsequence = null;
        this.MAPestimateLogProbability = Double.NaN;
    }

    @Override
    public <E extends UnivariateDistribution> E getFilteredPosterior(Variable var) {
        throw new UnsupportedOperationException("Operation not supported in Dynamic MAP Inference");
    }

    @Override
    public <E extends UnivariateDistribution> E getPredictivePosterior(Variable var, int nTimesAhead) {
        throw new UnsupportedOperationException("Operation not supported in Dynamic MAP Inference");
    }

    @Override
    public long getTimeIDOfLastEvidence() {
        return (long)this.evidence.stream().mapToDouble(DynamicAssignment::getTimeID).max().getAsDouble();
    }

    @Override
    public long getTimeIDOfPosterior() {
        throw new UnsupportedOperationException("Operation not supported in Dynamic MAP Inference");
    }

    @Override
    public DynamicBayesianNetwork getOriginalModel() {
        return this.model;
    }

    public void setEvidence(List<DynamicAssignment> evidence) {
        if (evidence == null) {
            this.evidence = null;
            this.staticEvidence = null;
            return;
        }
        long sequenceID = evidence.get(0).getSequenceID();
        for (DynamicAssignment dynAssig : evidence) {
            if (dynAssig.getSequenceID() != sequenceID) {
                System.out.println("Error: Different sequence IDs in the evidence");
                System.exit(-15);
            }
            if (dynAssig.getTimeID() >= (long)this.nTimeSteps || dynAssig.getTimeID() < 0L) {
                System.out.println("Error: Evidence time ID out of the range");
                System.exit(-20);
            }
            if (Double.isNaN(dynAssig.getValue(this.MAPvariable))) continue;
            System.out.println("Error: MAP variable should not be in the evidence");
            System.exit(-30);
        }
        this.evidence = evidence;
        if (this.unfoldedStaticModel != null) {
            this.staticEvidence = new HashMapAssignment(this.unfoldedStaticModel.getNumberOfVars());
            evidence.stream().forEach(dynamicAssignment -> {
                int time = (int)dynamicAssignment.getTimeID();
                Set<Variable> dynAssigVariables = dynamicAssignment.getVariables();
                for (Variable dynVariable : dynAssigVariables) {
                    Variable staticVariable = this.unfoldedStaticModel.getVariables().getVariableByName(dynVariable.getName() + "_t" + Integer.toString(time));
                    double varValue = dynamicAssignment.getValue(dynVariable);
                    this.staticEvidence.setValue(staticVariable, varValue);
                }
            });
        }
    }

    public List<List<UnivariateDistribution>> getGroupedPosteriorDistributions() {
        return this.allGroupedPosteriorDistributions;
    }

    public List<UnivariateDistribution> getUngroupedPosteriorDistributions() {
        return this.allUngroupedPosteriorDistributions;
    }

    @Override
    public void setModel(DynamicBayesianNetwork model) {
        this.model = model;
        this.unfoldedStaticModel = DynamicToStaticBNConverter.convertDBNtoBN(model, this.nTimeSteps);
    }

    public void setParallelMode(boolean parallelMode) {
        this.parallelMode = parallelMode;
    }

    public void setMAPvariable(Variable MAPvariable) {
        boolean parents0 = this.model.getDynamicDAG().getParentSetTime0(MAPvariable).getNumberOfParents() > 0;
        boolean parentsT = this.model.getDynamicDAG().getParentSetTimeT(MAPvariable).getParents().stream().anyMatch(parent -> !parent.isInterfaceVariable());
        if (parents0 || parentsT) {
            System.out.println("Error: The dynamic MAP variable must not have parents");
            System.exit(-5);
        }
        if (!MAPvariable.isMultinomial()) {
            System.out.println("Error: The dynamic MAP variable must be multinomial");
            System.exit(-10);
        }
        this.MAPvariable = MAPvariable;
        this.MAPvarName = MAPvariable.getName();
    }

    public void setNumberOfTimeSteps(int ntimeSteps) {
        if (ntimeSteps < 2) {
            System.out.println("Error: The number of time steps should be at least 2");
            System.exit(-12);
        }
        this.nTimeSteps = ntimeSteps;
        this.setModel(this.model);
    }

    public void setNumberOfMergedClassVars(int nMergedClassVars) {
        if (nMergedClassVars > this.nTimeSteps) {
            System.out.println("Error: The number of merged class variables should be less or equal than the number of time steps");
            System.exit(-13);
        }
        if (nMergedClassVars < 2 || nMergedClassVars > 10) {
            System.out.println("Error: The number of merged class variables should be between 2 and 10");
            System.exit(-14);
        }
        this.nMergedClassVars = nMergedClassVars;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public Assignment getMAPestimate() {
        return this.MAPestimate;
    }

    public int[] getMAPsequence() {
        return this.MAPsequence;
    }

    public double getMAPestimateLogProbability() {
        return this.MAPestimateLogProbability;
    }

    public double getMAPestimateProbability() {
        return Math.exp(this.MAPestimateLogProbability);
    }

    public List<BayesianNetwork> getMergedClassVarModels() {
        return this.mergedClassVarModels;
    }

    public BayesianNetwork getUnfoldedStaticModel() {
        return this.unfoldedStaticModel;
    }

    public Assignment getUnfoldedEvidence() {
        return this.staticEvidence;
    }

    public List<Variable> getReplicatedMAPVariables() {
        if (this.MAPestimate == null) {
            return null;
        }
        return this.getMAPestimate().getVariables().stream().sorted((var1, var2) -> var1.getVarID() > var2.getVarID() ? 1 : -1).collect(Collectors.toList());
    }

    public List<int[]> getBestSequencesForEachSubmodel() {
        return this.bestSequenceEachModel;
    }

    public void computeMergedClassVarModels() {
        DynamicDAG dynamicDAG = this.model.getDynamicDAG();
        DynamicVariables dynamicVariables = this.model.getDynamicVariables();
        this.mergedClassVarModels = new ArrayList<BayesianNetwork>(this.nMergedClassVars);
        IntStream.range(0, this.nMergedClassVars).forEachOrdered(modelNumber -> {
            Variables variables = this.obtainReplicatedStaticVariables(dynamicVariables, modelNumber);
            DAG dag = this.obtainStaticDAG(dynamicDAG, variables, modelNumber);
            BayesianNetwork bn = this.obtainStaticMergedClassVarNetwork(dag, variables, modelNumber);
            this.mergedClassVarModels.add(bn);
        });
    }

    @Override
    public void runInference() {
        if (this.MAPvariable == null || this.MAPvarName == null) {
            System.out.println("Error: The MAP variable has not been set");
            System.exit(-30);
        }
        if (this.mergedClassVarModels == null) {
            this.computeMergedClassVarModels();
        }
        this.runInference(SearchAlgorithm.VMP);
    }

    public void runInference(SearchAlgorithm searchAlgorithm) {
        if (this.MAPvariable == null || this.MAPvarName == null) {
            System.out.println("Error: The MAP variable has not been set");
            System.exit(-30);
        }
        if (this.mergedClassVarModels == null) {
            this.computeMergedClassVarModels();
        }
        if (this.unfoldedStaticModel == null) {
            this.unfoldedStaticModel = DynamicToStaticBNConverter.convertDBNtoBN(this.model, this.nTimeSteps);
        }
        if (this.evidence != null && this.staticEvidence == null) {
            this.staticEvidence = new HashMapAssignment(this.unfoldedStaticModel.getNumberOfVars());
            this.evidence.stream().forEach(dynamicAssignment -> {
                int time = (int)dynamicAssignment.getTimeID();
                Set<Variable> dynAssigVariables = dynamicAssignment.getVariables();
                for (Variable dynVariable : dynAssigVariables) {
                    Variable staticVariable = this.unfoldedStaticModel.getVariables().getVariableByName(dynVariable.getName() + "_t" + Integer.toString(time));
                    double varValue = dynamicAssignment.getValue(dynVariable);
                    this.staticEvidence.setValue(staticVariable, varValue);
                }
            });
        }
        ArrayList staticModelsInference = new ArrayList(this.nMergedClassVars);
        IntStream.range(0, this.nMergedClassVars).forEachOrdered(i -> {
            InferenceAlgorithm currentModelInference;
            switch (searchAlgorithm) {
                case VMP: {
                    currentModelInference = new VMP();
                    ((MessagePassingAlgorithm)currentModelInference).setThreshold(1.0E-4);
                    ((VMP)currentModelInference).setMaxIter(3000);
                    break;
                }
                default: {
                    currentModelInference = new ImportanceSamplingRobust();
                    Random random = new Random(this.seed);
                    currentModelInference.setSeed(random.nextInt());
                    this.seed = random.nextInt();
                    ((ImportanceSamplingRobust)currentModelInference).setSampleSize(this.sampleSize);
                }
            }
            currentModelInference.setParallelMode(this.parallelMode);
            currentModelInference.setModel(this.mergedClassVarModels.get(i));
            if (searchAlgorithm == SearchAlgorithm.IS) {
                ((ImportanceSamplingRobust)currentModelInference).setVariablesAPosteriori(this.mergedClassVarModels.get(i).getVariables().getListOfVariables().stream().filter(variable -> variable.getName().contains(this.groupedClassName)).collect(Collectors.toList()));
            }
            BayesianNetwork thisModel = this.mergedClassVarModels.get(i);
            if (this.staticEvidence != null) {
                HashMapAssignment thisEvidence = new HashMapAssignment();
                for (Variable varEvidence : this.staticEvidence.getVariables()) {
                    thisEvidence.setValue(thisModel.getVariables().getVariableByName(varEvidence.getName()), this.staticEvidence.getValue(varEvidence));
                }
                currentModelInference.setEvidence(thisEvidence);
            }
            currentModelInference.runInference();
            staticModelsInference.add(currentModelInference);
        });
        ArrayList<List<UnivariateDistribution>> posteriorMAPDistributions = new ArrayList<List<UnivariateDistribution>>();
        IntStream.range(0, this.nMergedClassVars).forEachOrdered(modelNumber -> {
            ArrayList currentModelPosteriorMAPDistributions = new ArrayList();
            int nReplicationsMAPVariable = (modelNumber == 0 ? 0 : 1) + (this.nTimeSteps - modelNumber) / this.nMergedClassVars + ((this.nTimeSteps - modelNumber) % this.nMergedClassVars == 0 ? 0 : 1);
            IntStream.range(0, nReplicationsMAPVariable).forEachOrdered(i -> currentModelPosteriorMAPDistributions.add(((InferenceAlgorithm)staticModelsInference.get(modelNumber)).getPosterior(i)));
            posteriorMAPDistributions.add(currentModelPosteriorMAPDistributions);
        });
        posteriorMAPDistributions.forEach(list -> {
            StringBuilder stringBuilder = new StringBuilder();
            list.forEach(uniDist -> {
                stringBuilder.append(Arrays.toString(uniDist.getParameters()));
                stringBuilder.append(" ,  ");
            });
        });
        this.allGroupedPosteriorDistributions = posteriorMAPDistributions;
        this.bestSequenceEachModel = new ArrayList<int[]>();
        IntStream.range(0, this.nMergedClassVars).forEachOrdered(modelNumber -> {
            int[] thisModelBestSequence = new int[this.nTimeSteps];
            int indexSequence = 0;
            List thisModelPosteriors = (List)posteriorMAPDistributions.get(modelNumber);
            for (int k = 0; k < thisModelPosteriors.size(); ++k) {
                UnivariateDistribution thisDistribution = (UnivariateDistribution)thisModelPosteriors.get(k);
                int indexMaxProbability = (int)this.argMax(thisDistribution.getParameters())[1];
                int thisDistribNumberOfMergedVars = (int)Math.round(Math.log(thisDistribution.getVariable().getNumberOfStates()) / Math.log(this.MAPvariable.getNumberOfStates()));
                String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(indexMaxProbability), 10), this.MAPvariable.getNumberOfStates());
                m_base_nStates = StringUtils.leftPad(m_base_nStates, thisDistribNumberOfMergedVars, '0');
                for (int j = 0; j < m_base_nStates.length(); ++j) {
                    thisModelBestSequence[indexSequence] = Integer.parseInt(m_base_nStates.substring(j, j + 1));
                    ++indexSequence;
                }
            }
            this.bestSequenceEachModel.add(thisModelBestSequence);
        });
        List<double[]> conditionalDistributionsMAPvariable = this.obtainMAPVariableConditionalDistributions(posteriorMAPDistributions);
        StringBuilder stringBuilder = new StringBuilder();
        conditionalDistributionsMAPvariable.forEach(conDistr -> {
            stringBuilder.append(Arrays.toString(conDistr));
            stringBuilder.append(" ,  ");
        });
        this.computeMostProbableSequence(conditionalDistributionsMAPvariable);
    }

    public void runInferenceUngroupedMAPVariable(SearchAlgorithm searchAlgorithm) {
        InferenceAlgorithm staticModelInference;
        if (this.MAPvariable == null || this.MAPvarName == null) {
            System.out.println("Error: The MAP variable has not been set");
            System.exit(-30);
        }
        if (this.unfoldedStaticModel == null) {
            this.unfoldedStaticModel = DynamicToStaticBNConverter.convertDBNtoBN(this.model, this.nTimeSteps);
        }
        if (this.evidence != null && this.staticEvidence == null) {
            this.staticEvidence = new HashMapAssignment(this.unfoldedStaticModel.getNumberOfVars());
            this.evidence.stream().forEach(dynamicAssignment -> {
                int time = (int)dynamicAssignment.getTimeID();
                Set<Variable> dynAssigVariables = dynamicAssignment.getVariables();
                for (Variable dynVariable : dynAssigVariables) {
                    Variable staticVariable = this.unfoldedStaticModel.getVariables().getVariableByName(dynVariable.getName() + "_t" + Integer.toString(time));
                    double varValue = dynamicAssignment.getValue(dynVariable);
                    this.staticEvidence.setValue(staticVariable, varValue);
                }
            });
        }
        switch (searchAlgorithm) {
            case VMP: {
                staticModelInference = new VMP();
                ((MessagePassingAlgorithm)staticModelInference).setThreshold(1.0E-4);
                ((MessagePassingAlgorithm)staticModelInference).setMaxIter(3000);
                break;
            }
            default: {
                ImportanceSamplingRobust importanceSampling = new ImportanceSamplingRobust();
                importanceSampling.setSampleSize(this.sampleSize);
                Random random = new Random(this.seed);
                importanceSampling.setSeed(random.nextInt());
                staticModelInference = importanceSampling;
            }
        }
        staticModelInference.setParallelMode(this.parallelMode);
        staticModelInference.setModel(this.unfoldedStaticModel);
        if (searchAlgorithm == SearchAlgorithm.IS) {
            ((ImportanceSamplingRobust)staticModelInference).setVariablesAPosteriori(this.unfoldedStaticModel.getVariables().getListOfVariables().stream().filter(variable -> variable.getName().contains(this.MAPvarName)).collect(Collectors.toList()));
        }
        if (this.evidence != null) {
            staticModelInference.setEvidence(this.staticEvidence);
        }
        staticModelInference.runInference();
        ArrayList<UnivariateDistribution> posteriorMAPDistributionsStaticModel = new ArrayList<UnivariateDistribution>();
        IntStream.range(0, this.nTimeSteps).forEachOrdered(i -> posteriorMAPDistributionsStaticModel.add((UnivariateDistribution)staticModelInference.getPosterior(i)));
        this.allUngroupedPosteriorDistributions = posteriorMAPDistributionsStaticModel;
        double[] probabilities = posteriorMAPDistributionsStaticModel.stream().map(dist -> this.argMax(dist.getParameters())).mapToDouble(array -> array[0]).toArray();
        double MAPsequenceProbability = Math.exp(Arrays.stream(probabilities).map(prob -> Math.log(prob)).sum());
        int[] MAPsequence = posteriorMAPDistributionsStaticModel.stream().map(dist -> this.argMax(dist.getParameters())).mapToInt(array -> (int)array[1]).toArray();
        this.MAPestimate = new HashMapAssignment(this.nTimeSteps);
        IntStream.range(0, this.nTimeSteps).forEach(t -> {
            Variables variables = Serialization.deepCopy(this.unfoldedStaticModel.getVariables());
            Variable currentVar = variables.getVariableByName(this.MAPvarName + "_t" + Integer.toString(t)) != null ? variables.getVariableByName(this.MAPvarName + "_t" + Integer.toString(t)) : variables.newMultinomialVariable(this.MAPvarName + "_t" + Integer.toString(t), this.MAPvariable.getNumberOfStates());
            this.MAPestimate.setValue(currentVar, MAPsequence[t]);
        });
        this.MAPestimateLogProbability = Math.log(MAPsequenceProbability);
        this.MAPsequence = MAPsequence;
    }

    private List<double[]> obtainMAPVariableConditionalDistributions(List<List<UnivariateDistribution>> posteriorMAPVariableDistributions) {
        ArrayList<double[]> listCondDistributions = new ArrayList<double[]>(this.nTimeSteps);
        int nStates = this.MAPvariable.getNumberOfStates();
        IntStream.range(0, this.nTimeSteps).forEachOrdered(timeStep -> {
            int baseModelIndex = (timeStep + 1) % this.nMergedClassVars;
            int baseDistributionIndex = timeStep >= baseModelIndex ? (baseModelIndex == 0 ? 0 : 1) + (timeStep - baseModelIndex) / this.nMergedClassVars : (timeStep - baseModelIndex) / this.nMergedClassVars;
            double[] baseDistributionProbabilities = ((UnivariateDistribution)((List)posteriorMAPVariableDistributions.get(baseModelIndex)).get(baseDistributionIndex)).getParameters();
            int nStatesBaseDistribution = baseDistributionProbabilities.length;
            int baseDistrib_nMergedVars = (int)Math.round(Math.log(nStatesBaseDistribution) / Math.log(nStates));
            double[] combinedConditionalDistributionProbabilities = IntStream.range(0, this.nMergedClassVars).mapToObj(modelNumber -> {
                if (modelNumber == baseModelIndex) {
                    return baseDistributionProbabilities;
                }
                int distributionIndex = timeStep >= modelNumber ? (modelNumber == 0 ? 0 : 1) + (timeStep - modelNumber) / this.nMergedClassVars : (timeStep - modelNumber) / this.nMergedClassVars;
                int currentVarIndex = timeStep >= modelNumber ? (timeStep - modelNumber) % this.nMergedClassVars : timeStep;
                UnivariateDistribution currentDistrib = (UnivariateDistribution)((List)posteriorMAPVariableDistributions.get(modelNumber)).get(distributionIndex);
                double[] probabilities = new double[nStatesBaseDistribution];
                int currentDistrib_nMergedVars = (int)Math.round(Math.log(currentDistrib.getVariable().getNumberOfStates()) / Math.log(nStates));
                int current_nMergedVarsBaseDist = (int)Math.round(Math.log(baseDistributionProbabilities.length) / Math.log(nStates));
                if (distributionIndex == 0) {
                    int m = 0;
                    while ((double)m < Math.pow(nStates, currentDistrib_nMergedVars)) {
                        int currentState;
                        String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(m), 10), nStates);
                        m_base_nStates = StringUtils.leftPad(m_base_nStates, currentDistrib_nMergedVars, '0');
                        int index_init = currentVarIndex + 1 - baseDistrib_nMergedVars;
                        int index_end = currentVarIndex + 1;
                        String statesSequence = m_base_nStates.substring(index_init, index_end);
                        int n = currentState = Integer.parseInt(statesSequence, nStates);
                        probabilities[n] = probabilities[n] + currentDistrib.getParameters()[m];
                        ++m;
                    }
                } else {
                    UnivariateDistribution previousDistrib = (UnivariateDistribution)((List)posteriorMAPVariableDistributions.get(modelNumber)).get(distributionIndex - 1);
                    int previousDistrib_nMergedVars = (int)Math.round(Math.log(previousDistrib.getVariable().getNumberOfStates()) / Math.log(nStates));
                    int n = 0;
                    while ((double)n < Math.pow(nStates, previousDistrib_nMergedVars)) {
                        String n_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(n), 10), nStates);
                        n_base_nStates = StringUtils.leftPad(n_base_nStates, previousDistrib_nMergedVars, '0');
                        int m = 0;
                        while ((double)m < Math.pow(nStates, currentDistrib_nMergedVars)) {
                            int currentState;
                            String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(m), 10), nStates);
                            m_base_nStates = StringUtils.leftPad(m_base_nStates, currentDistrib_nMergedVars, '0');
                            String n_concat_m_base_nStates = n_base_nStates.concat(m_base_nStates);
                            int index_init = previousDistrib_nMergedVars + currentVarIndex + 1 - baseDistrib_nMergedVars;
                            int index_end = previousDistrib_nMergedVars + currentVarIndex + 1;
                            String statesSequence = n_concat_m_base_nStates.substring(index_init, index_end);
                            int n2 = currentState = Integer.parseInt(statesSequence, nStates);
                            probabilities[n2] = probabilities[n2] + previousDistrib.getParameters()[n] * currentDistrib.getParameters()[m];
                            ++m;
                        }
                        ++n;
                    }
                }
                return probabilities;
            }).reduce(new double[baseDistributionProbabilities.length], (doubleArray1, doubleArray2) -> {
                if (((double[])doubleArray1).length != ((double[])doubleArray2).length) {
                    System.exit(-40);
                }
                for (int i = 0; i < ((double[])doubleArray1).length; ++i) {
                    int n = i;
                    doubleArray1[n] = doubleArray1[n] + 1.0 / (double)this.nMergedClassVars * doubleArray2[i];
                }
                return doubleArray1;
            });
            listCondDistributions.add(combinedConditionalDistributionProbabilities);
        });
        return listCondDistributions;
    }

    private void computeMostProbableSequence(List<double[]> posteriorDistributionsMAPvariable) {
        int[] MAPsequence = new int[this.nTimeSteps];
        int nStates = this.MAPvariable.getNumberOfStates();
        int[] argMaxValues = new int[this.nTimeSteps - 1];
        double MAPsequenceProbability = -1.0;
        double[] current_max_probs = new double[(int)Math.pow(nStates, this.nMergedClassVars - 1)];
        double[] previous_max_probs = new double[(int)Math.pow(nStates, this.nMergedClassVars - 1)];
        for (int t = this.nTimeSteps - 1; t >= 1; --t) {
            int i;
            double[] currentDistProbabilities = posteriorDistributionsMAPvariable.get(t);
            if (Arrays.stream(currentDistProbabilities).anyMatch(Double::isNaN) && (i = 0) < (MAPsequence = new int[this.nTimeSteps]).length) {
                MAPsequence[i] = -1;
                return;
            }
            int currentDistrib_nMergedVars = (int)Math.round(Math.log(currentDistProbabilities.length) / Math.log(nStates));
            current_max_probs = new double[(int)Math.pow(nStates, currentDistrib_nMergedVars - 1)];
            if (t == this.nTimeSteps - 1) {
                previous_max_probs = Arrays.stream(previous_max_probs).map(d -> 1.0).toArray();
            }
            int m = 0;
            while ((double)m < Math.pow(nStates, currentDistrib_nMergedVars)) {
                int currentStateLastVars;
                int currentStateFirstVars;
                String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(m), 10), nStates);
                m_base_nStates = StringUtils.leftPad(m_base_nStates, currentDistrib_nMergedVars, '0');
                if (t > 0) {
                    String stateFirstVars = m_base_nStates.substring(0, currentDistrib_nMergedVars - 1);
                    currentStateFirstVars = Integer.parseInt(stateFirstVars, nStates);
                    String stateLastVars = m_base_nStates.substring(1, currentDistrib_nMergedVars);
                    currentStateLastVars = Integer.parseInt(stateLastVars, nStates);
                } else {
                    currentStateFirstVars = 0;
                    currentStateLastVars = Integer.parseInt(m_base_nStates, nStates);
                }
                double currentProb = currentDistProbabilities[m] * previous_max_probs[currentStateLastVars];
                double maxProb = current_max_probs[currentStateFirstVars];
                if (currentProb > maxProb) {
                    current_max_probs[currentStateFirstVars] = currentProb;
                }
                ++m;
            }
            argMaxValues[t - 1] = (int)this.argMax(current_max_probs)[1];
            previous_max_probs = current_max_probs;
            if (t != 1) continue;
            MAPsequenceProbability = this.argMax(current_max_probs)[0];
        }
        MAPsequence[0] = argMaxValues[0];
        int thisVarMAPState = 0;
        for (int t = 1; t < this.nTimeSteps; ++t) {
            double[] current_probs = posteriorDistributionsMAPvariable.get(t);
            StringBuilder prevVarsStateBuilder = new StringBuilder();
            int j_max = Math.min(this.nMergedClassVars - 1, t);
            for (int j = 0; j < Math.min(this.nMergedClassVars - 1, t); ++j) {
                prevVarsStateBuilder.append(Integer.toString(MAPsequence[t - j_max + j]));
            }
            String prevVarsState = prevVarsStateBuilder.toString();
            double maxProb = -1.0;
            for (int j = 0; j < nStates; ++j) {
                int currentState = Integer.parseInt(prevVarsState.concat(Integer.toString(j)), nStates);
                if (!(current_probs[currentState] > maxProb)) continue;
                maxProb = current_probs[currentState];
                thisVarMAPState = j;
            }
            MAPsequence[t] = thisVarMAPState;
        }
        this.MAPestimateLogProbability = Arrays.stream(MAPsequence).anyMatch(value -> value < 0) ? Double.NaN : Math.log(MAPsequenceProbability);
        this.MAPsequence = MAPsequence;
    }

    private double[] argMax(double[] values) {
        double maxValue = Arrays.stream(values).max().getAsDouble();
        double indexMaxValue = -1.0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != maxValue) continue;
            indexMaxValue = i;
        }
        return new double[]{maxValue, indexMaxValue};
    }

    private Variables obtainReplicatedStaticVariables(DynamicVariables dynamicVariables, int modelNumber) {
        Variables variables = new Variables();
        int replicationsMAPVariable = (modelNumber == 0 ? 0 : 1) + (this.nTimeSteps - modelNumber) / this.nMergedClassVars + ((this.nTimeSteps - modelNumber) % this.nMergedClassVars == 0 ? 0 : 1);
        IntStream.range(0, replicationsMAPVariable).forEach(mergedClassVarIndex -> {
            int nStatesMAPVariable = (int)Math.pow(this.MAPvariable.getNumberOfStates(), this.nMergedClassVars);
            if (modelNumber != 0 && mergedClassVarIndex == 0) {
                nStatesMAPVariable = (int)Math.pow(this.MAPvariable.getNumberOfStates(), modelNumber);
            }
            if ((this.nTimeSteps - modelNumber) % this.nMergedClassVars != 0 && mergedClassVarIndex == replicationsMAPVariable - 1) {
                nStatesMAPVariable = (int)Math.pow(this.MAPvariable.getNumberOfStates(), (this.nTimeSteps - modelNumber) % this.nMergedClassVars);
            }
            variables.newMultinomialVariable(this.groupedClassName + "_t" + Integer.toString(mergedClassVarIndex), nStatesMAPVariable);
        });
        dynamicVariables.getListOfDynamicVariables().stream().filter(var -> !var.equals(this.MAPvariable)).forEach(dynVar -> IntStream.range(0, this.nTimeSteps).forEach(i -> {
            VariableBuilder aux = dynVar.getVariableBuilder();
            aux.setName(dynVar.getName() + "_t" + Integer.toString(i));
            variables.newVariable(aux);
        }));
        return variables;
    }

    private DAG obtainStaticDAG(DynamicDAG dynamicDAG, Variables variables, int modelNumber) {
        DAG dag = new DAG(variables);
        DynamicVariables dynamicVariables = dynamicDAG.getDynamicVariables();
        int replicationsMAPVariable = (modelNumber == 0 ? 0 : 1) + (this.nTimeSteps - modelNumber) / this.nMergedClassVars + ((this.nTimeSteps - modelNumber) % this.nMergedClassVars == 0 ? 0 : 1);
        IntStream.range(1, replicationsMAPVariable).forEach(mergedClassVarIndex -> {
            Variable staticVar = variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(mergedClassVarIndex));
            dag.getParentSet(staticVar).addParent(variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(mergedClassVarIndex - 1)));
        });
        dynamicVariables.getListOfDynamicVariables().stream().filter(var -> !var.equals(this.MAPvariable)).forEach(dynVar -> {
            Variable staticVar0 = variables.getVariableByName(dynVar.getName() + "_t0");
            List<Variable> parents0 = dynamicDAG.getParentSetTime0((Variable)dynVar).getParents();
            parents0.stream().filter(parent -> parent.equals(this.MAPvariable)).forEach(parentaux2 -> dag.getParentSet(staticVar0).addParent(variables.getVariableByName(this.groupedClassName + "_t0")));
            parents0.stream().filter(parent -> !parent.equals(this.MAPvariable)).forEach(parentaux2 -> dag.getParentSet(staticVar0).addParent(variables.getVariableByName(parentaux2.getName() + "_t0")));
            IntStream.range(1, this.nTimeSteps).forEach(timeStep -> {
                int indexMAPReplication;
                Variable staticVar = variables.getVariableByName(dynVar.getName() + "_t" + Integer.toString(timeStep));
                List<Variable> parents = dynamicDAG.getParentSetTimeT((Variable)dynVar).getParents();
                int n = timeStep >= modelNumber ? (modelNumber == 0 ? 0 : 1) + (timeStep - modelNumber) / this.nMergedClassVars : (indexMAPReplication = (timeStep - modelNumber) / this.nMergedClassVars);
                if (indexMAPReplication >= replicationsMAPVariable) {
                    System.out.println("Error in obtainStaticDAG: Bad MAP variable index");
                    System.exit(-50);
                }
                List parentsInterface = parents.stream().filter(parentVar -> parentVar.isInterfaceVariable()).collect(Collectors.toList());
                parentsInterface.stream().filter(parent -> parent.equals(this.MAPvariable)).forEach(parentVar -> dag.getParentSet(staticVar).addParent(variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(indexMAPReplication - 1))));
                parentsInterface.stream().filter(parent -> !parent.equals(this.MAPvariable)).forEach(parentVar -> dag.getParentSet(staticVar).addParent(variables.getVariableByName(parentVar.getName().replace("_Interface", "_t" + Integer.toString(timeStep - 1)))));
                List parentsNotInterface = parents.stream().filter(parentVar -> !parentVar.isInterfaceVariable()).collect(Collectors.toList());
                parentsNotInterface.stream().filter(parent -> parent.equals(this.MAPvariable)).forEach(parentVar -> dag.getParentSet(staticVar).addParent(variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(indexMAPReplication))));
                parentsNotInterface.stream().filter(parent -> !parent.equals(this.MAPvariable)).forEach(parentVar -> dag.getParentSet(staticVar).addParent(variables.getVariableByName(parentVar.getName() + "_t" + Integer.toString(timeStep))));
            });
        });
        return dag;
    }

    private Multinomial groupedDistributionMAPVariableTime0(Variable dynVar, Variable staticVar, ConditionalDistribution conDist0, ConditionalDistribution conDistT, int modelNumber) {
        if (modelNumber == 1) {
            return (Multinomial)conDist0;
        }
        HashMapAssignment assignment0 = new HashMapAssignment(1);
        int nStates = dynVar.getNumberOfStates();
        int nMergedStates = staticVar.getNumberOfStates();
        Multinomial multinomial = new Multinomial(staticVar);
        double[] probs = new double[nMergedStates];
        int probs_index = 0;
        int repetitionsConDistT = (int)Math.round(Math.log(nMergedStates) / Math.log(nStates) - 1.0);
        for (int k = 0; k < nStates; ++k) {
            assignment0.setValue(dynVar, k);
            double prob0 = conDist0.getConditionalProbability(assignment0);
            int m = 0;
            while ((double)m < Math.pow(nStates, repetitionsConDistT)) {
                String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(m), 10), nStates);
                m_base_nStates = StringUtils.leftPad(m_base_nStates, repetitionsConDistT, '0');
                double probT = 1.0;
                for (int n = 0; n < m_base_nStates.length(); ++n) {
                    int currentState = Integer.parseInt(m_base_nStates.substring(n, n + 1));
                    int previousState = n >= 1 ? Integer.parseInt(m_base_nStates.substring(n - 1, n)) : k;
                    HashMapAssignment assignment1 = new HashMapAssignment(2);
                    assignment1.setValue(dynVar.getInterfaceVariable(), previousState);
                    assignment1.setValue(dynVar, currentState);
                    probT *= conDistT.getConditionalProbability(assignment1);
                }
                probs[probs_index] = prob0 * probT;
                ++probs_index;
                ++m;
            }
        }
        multinomial.setProbabilities(probs);
        return multinomial;
    }

    private Multinomial_MultinomialParents groupedDistributionMAPVariableTimeT(Variable dynVar, Variable staticVar, int nStatesStaticVarParent, List<Variable> parents, ConditionalDistribution conDistT, int modelNumber) {
        Multinomial_MultinomialParents multinomial_multinomialParents = new Multinomial_MultinomialParents(staticVar, parents);
        int nStates = dynVar.getNumberOfStates();
        int nMergedStates = staticVar.getNumberOfStates();
        int repetitionsConDistT = (int)Math.round(Math.log(nMergedStates) / Math.log(nStates));
        for (int s = 0; s < nStatesStaticVarParent; ++s) {
            int parentState = s % nStates;
            double[] probs1 = new double[nMergedStates];
            int probs_index1 = 0;
            int m = 0;
            while ((double)m < Math.pow(nStates, repetitionsConDistT)) {
                String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(m), 10), nStates);
                m_base_nStates = StringUtils.leftPad(m_base_nStates, repetitionsConDistT, '0');
                double probT = 1.0;
                for (int n = 0; n < m_base_nStates.length(); ++n) {
                    int currentState = Integer.parseInt(m_base_nStates.substring(n, n + 1));
                    int previousState = n >= 1 ? Integer.parseInt(m_base_nStates.substring(n - 1, n)) : parentState;
                    HashMapAssignment assignment1 = new HashMapAssignment(2);
                    assignment1.setValue(dynVar.getInterfaceVariable(), previousState);
                    assignment1.setValue(dynVar, currentState);
                    probT *= conDistT.getConditionalProbability(assignment1);
                }
                probs1[probs_index1] = probT;
                ++probs_index1;
                ++m;
            }
            Multinomial multinomial = new Multinomial(staticVar);
            multinomial.setProbabilities(probs1);
            multinomial_multinomialParents.setMultinomial(s, multinomial);
        }
        return multinomial_multinomialParents;
    }

    private BayesianNetwork obtainStaticMergedClassVarNetwork(DAG dag, Variables variables, int modelNumber) {
        Multinomial_MultinomialParents generalConditionalDistTimeT;
        ConditionalDistribution conDist_dynamic;
        List<Variable> parents;
        Variable staticVar_interface;
        Variable staticVar_current;
        DynamicDAG dynamicDAG = this.model.getDynamicDAG();
        BayesianNetwork bn = new BayesianNetwork(dag);
        int replicationsMAPVariable = (modelNumber == 0 ? 0 : 1) + (this.nTimeSteps - modelNumber) / this.nMergedClassVars + ((this.nTimeSteps - modelNumber) % this.nMergedClassVars == 0 ? 0 : 1);
        Variable staticVar = variables.getVariableByName(this.groupedClassName + "_t0");
        Variable dynVar = this.model.getDynamicVariables().getVariableByName(this.MAPvarName);
        ConditionalDistribution conDist0 = Serialization.deepCopy(this.model.getConditionalDistributionsTime0().get(dynVar.getVarID()));
        ConditionalDistribution conDistT = Serialization.deepCopy(this.model.getConditionalDistributionsTimeT().get(dynVar.getVarID()));
        Multinomial multinomial = this.groupedDistributionMAPVariableTime0(dynVar, staticVar, conDist0, conDistT, modelNumber);
        multinomial.setVar(staticVar);
        bn.setConditionalDistribution(staticVar, multinomial);
        if (modelNumber == 0 && (replicationsMAPVariable > 2 || replicationsMAPVariable == 2 && this.nTimeSteps >= 4)) {
            staticVar_current = variables.getVariableByName(this.groupedClassName + "_t1");
            staticVar_interface = variables.getVariableByName(this.groupedClassName + "_t0");
            parents = bn.getDAG().getParentSet(staticVar_current).getParents();
            conDist_dynamic = Serialization.deepCopy(conDistT);
            generalConditionalDistTimeT = this.groupedDistributionMAPVariableTimeT(dynVar, staticVar_current, staticVar_interface.getNumberOfStates(), parents, conDist_dynamic, modelNumber);
        } else if (modelNumber > 0 && (replicationsMAPVariable > 3 || replicationsMAPVariable == 3 && this.nTimeSteps >= 5)) {
            staticVar_current = variables.getVariableByName(this.groupedClassName + "_t2");
            staticVar_interface = variables.getVariableByName(this.groupedClassName + "_t1");
            parents = bn.getDAG().getParentSet(staticVar_current).getParents();
            conDist_dynamic = Serialization.deepCopy(conDistT);
            generalConditionalDistTimeT = this.groupedDistributionMAPVariableTimeT(dynVar, staticVar_current, staticVar_interface.getNumberOfStates(), parents, conDist_dynamic, modelNumber);
        } else {
            generalConditionalDistTimeT = new Multinomial_MultinomialParents(staticVar, bn.getDAG().getParentSet(staticVar).getParents());
        }
        if (modelNumber != 0) {
            Variable staticVar0 = variables.getVariableByName(this.groupedClassName + "_t1");
            Variable staticVar0_interface = variables.getVariableByName(this.groupedClassName + "_t0");
            parents = bn.getDAG().getParentSet(staticVar0).getParents();
            conDist_dynamic = Serialization.deepCopy(this.model.getConditionalDistributionsTimeT().get(dynVar.getVarID()));
            Multinomial_MultinomialParents conditionalDistTime1 = this.groupedDistributionMAPVariableTimeT(dynVar, staticVar0, staticVar0_interface.getNumberOfStates(), parents, conDist_dynamic, modelNumber);
            ((Distribution)conditionalDistTime1).setVar(staticVar0);
            bn.setConditionalDistribution(staticVar0, conditionalDistTime1);
        }
        int initialTimeStep = 2;
        int finalTimeStep = replicationsMAPVariable - 1;
        if (modelNumber == 0) {
            initialTimeStep = 1;
        }
        if ((this.nTimeSteps - modelNumber) % this.nMergedClassVars == 0) {
            finalTimeStep = replicationsMAPVariable;
        }
        IntStream.range(initialTimeStep, finalTimeStep).forEach(timeStep -> {
            Variable staticVar1 = variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(timeStep));
            ConditionalDistribution conditionalDistribution = Serialization.deepCopy(generalConditionalDistTimeT);
            conditionalDistribution.setConditioningVariables(dag.getParentSet(staticVar1).getParents());
            conditionalDistribution.setVar(staticVar1);
            bn.setConditionalDistribution(staticVar1, conditionalDistribution);
        });
        if ((this.nTimeSteps - modelNumber) % this.nMergedClassVars != 0) {
            Variable staticVar1 = variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(replicationsMAPVariable - 1));
            Variable staticVar1_interface = variables.getVariableByName(this.groupedClassName + "_t" + Integer.toString(replicationsMAPVariable - 2));
            List<Variable> parents1 = bn.getDAG().getParentSet(staticVar1).getParents();
            Multinomial_MultinomialParents lastConDist = this.groupedDistributionMAPVariableTimeT(dynVar, staticVar1, staticVar1_interface.getNumberOfStates(), parents1, conDistT, modelNumber);
            bn.setConditionalDistribution(staticVar1, lastConDist);
        }
        List<Variable> dynVariables = this.model.getDynamicVariables().getListOfDynamicVariables();
        List dynVariablesWithClassParent = dynVariables.stream().filter(var -> !var.equals(this.MAPvariable)).filter(var -> dynamicDAG.getParentSetTime0((Variable)var).contains(this.MAPvariable)).collect(Collectors.toList());
        List dynVariablesNoClassParent = dynVariables.stream().filter(var -> !var.equals(this.MAPvariable)).filter(var -> !dynamicDAG.getParentSetTime0((Variable)var).contains(this.MAPvariable)).collect(Collectors.toList());
        dynVariablesWithClassParent.stream().forEach(dynVariable -> IntStream.range(0, this.nTimeSteps).forEachOrdered(timeStep -> {
            ConditionalDistribution dynamicConDist = (ConditionalDistribution)Serialization.deepCopy(timeStep == 0 ? this.model.getConditionalDistributionTime0((Variable)dynVariable) : this.model.getConditionalDistributionTimeT((Variable)dynVariable));
            Variable staticVar2 = variables.getVariableByName(dynVariable.getName() + "_t" + Integer.toString(timeStep));
            List<Variable> parentList = bn.getDAG().getParentSet(staticVar2).getParents();
            ConditionalDistribution staticVar2Distribution = this.obtainDistributionOfMAPChildren(staticVar2, dynamicConDist, parentList, modelNumber, timeStep);
            bn.setConditionalDistribution(staticVar2, staticVar2Distribution);
        }));
        dynVariablesNoClassParent.stream().forEach(dynVariable -> {
            ConditionalDistribution conditionalDistribution = (ConditionalDistribution)Serialization.deepCopy(this.model.getConditionalDistributionTime0((Variable)dynVariable));
            Variable staticVar1 = variables.getVariableByName(dynVariable.getName() + "_t0");
            List<Variable> thisVarParents = conditionalDistribution.getConditioningVariables();
            thisVarParents = thisVarParents.stream().map(parent -> variables.getVariableByName(parent.getName() + "_t0")).collect(Collectors.toList());
            conditionalDistribution.setConditioningVariables(thisVarParents);
            conditionalDistribution.setVar(staticVar1);
            bn.setConditionalDistribution(staticVar1, conditionalDistribution);
            IntStream.range(1, this.nTimeSteps).forEach(i -> {
                ConditionalDistribution conditionalDistribution1 = (ConditionalDistribution)Serialization.deepCopy(this.model.getConditionalDistributionTimeT((Variable)dynVariable));
                Variable staticVar2 = variables.getVariableByName(dynVariable.getName() + "_t" + Integer.toString(i));
                List<Variable> thisVarParents1 = conditionalDistribution1.getConditioningVariables();
                thisVarParents1 = thisVarParents1.stream().map(parent -> {
                    if (parent.getName().contains("_Interface")) {
                        return variables.getVariableByName(parent.getName().replace("_Interface", "_t" + Integer.toString(i - 1)));
                    }
                    return variables.getVariableByName(parent.getName() + "_t" + Integer.toString(i));
                }).collect(Collectors.toList());
                conditionalDistribution1.setConditioningVariables(thisVarParents1);
                conditionalDistribution1.setVar(staticVar2);
                bn.setConditionalDistribution(staticVar2, conditionalDistribution1);
            });
        });
        return bn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConditionalDistribution obtainDistributionOfMAPChildren(Variable staticVariable, ConditionalDistribution dynamicConditionalDistribution, List<Variable> parentList, int modelNumber, int time_step) {
        ConditionalDistribution staticVarConDist;
        boolean allParentsMultinomial = parentList.stream().allMatch(parent -> parent.isMultinomial());
        List<Variable> multinomialParents = parentList.stream().filter(parent -> parent.isMultinomial()).collect(Collectors.toList());
        List<Variable> continuousParents = parentList.stream().filter(parent -> !parent.isMultinomial()).collect(Collectors.toList());
        int distributionType = -1;
        if (staticVariable.isMultinomial()) {
            distributionType = 0;
            staticVarConDist = new Multinomial_MultinomialParents(staticVariable, parentList);
        } else {
            if (!staticVariable.isNormal()) throw new IllegalArgumentException("Unrecognized DistributionType. ");
            int nMultinomialParents = multinomialParents.size();
            int nNormalParents = continuousParents.size();
            if (nNormalParents > 0 && nMultinomialParents == 0) {
                distributionType = 1;
                staticVarConDist = new ConditionalLinearGaussian(staticVariable, parentList);
            } else if (nNormalParents == 0 && nMultinomialParents > 0) {
                distributionType = 2;
                staticVarConDist = new Normal_MultinomialParents(staticVariable, parentList);
            } else {
                if (nNormalParents <= 0 || nMultinomialParents <= 0) throw new IllegalArgumentException("Unrecognized DistributionType. ");
                distributionType = 3;
                staticVarConDist = new Normal_MultinomialNormalParents(staticVariable, parentList);
            }
        }
        int nStatesMultinomialParents = (int)Math.round(Math.exp(multinomialParents.stream().mapToDouble(parent -> Math.log(parent.getNumberOfStates())).sum()));
        int nStatesMAPVariable = this.MAPvariable.getNumberOfStates();
        for (int m = 0; m < nStatesMultinomialParents; ++m) {
            Assignment staticParentsConfiguration = MultinomialIndex.getVariableAssignmentFromIndex(multinomialParents, m);
            HashMapAssignment dynamicParentsConfiguration = new HashMapAssignment(multinomialParents.size());
            IntStream.range(0, multinomialParents.size()).forEach(k -> {
                Variable currentParent = (Variable)multinomialParents.get(k);
                int parentValue = (int)staticParentsConfiguration.getValue(currentParent);
                if (currentParent.getName().contains(this.groupedClassName)) {
                    int dynamicParentState;
                    String parentName = currentParent.getName().replace(this.groupedClassName, this.MAPvarName).replaceAll("_t\\d+", "");
                    Variable dynCurrentParent = this.model.getDynamicVariables().getVariableByName(parentName);
                    int nMergedStates = currentParent.getNumberOfStates();
                    int repetitionsConDistT = (int)Math.round(Math.log(nMergedStates) / Math.log(nStatesMAPVariable));
                    int indexCurrentParentState = time_step >= modelNumber ? (time_step - modelNumber) % this.nMergedClassVars : time_step;
                    String m_base_nStates = Integer.toString(Integer.parseInt(Integer.toString(parentValue), 10), nStatesMAPVariable);
                    m_base_nStates = StringUtils.leftPad(m_base_nStates, repetitionsConDistT, '0');
                    int dynParentValue = dynamicParentState = Integer.parseInt(m_base_nStates.substring(indexCurrentParentState, indexCurrentParentState + 1));
                    dynamicParentsConfiguration.setValue(dynCurrentParent, dynParentValue);
                } else if (((Variable)multinomialParents.get(k)).getName().endsWith("_t" + Integer.toString(time_step - 1))) {
                    String parentName = ((Variable)multinomialParents.get(k)).getName().replaceFirst("_t\\d+", "");
                    Variable dynParent = this.model.getDynamicVariables().getVariableByName(parentName);
                    dynamicParentsConfiguration.setValue(dynParent.getInterfaceVariable(), parentValue);
                } else {
                    String parentName = ((Variable)multinomialParents.get(k)).getName().replaceFirst("_t\\d+", "");
                    Variable dynParent = this.model.getDynamicVariables().getVariableByName(parentName);
                    dynamicParentsConfiguration.setValue(dynParent, parentValue);
                }
            });
            if (distributionType == 0) {
                Multinomial_MultinomialParents multinomial_multinomialParents = (Multinomial_MultinomialParents)dynamicConditionalDistribution;
                Multinomial multinomial1 = multinomial_multinomialParents.getMultinomial(dynamicParentsConfiguration);
                multinomial1.setVar(staticVariable);
                multinomial1.setConditioningVariables(multinomialParents);
                ((Multinomial_MultinomialParents)staticVarConDist).setMultinomial(m, multinomial1);
                continue;
            }
            if (distributionType == 2) {
                Normal_MultinomialParents normal_multinomialParents = (Normal_MultinomialParents)dynamicConditionalDistribution;
                Normal normal1 = normal_multinomialParents.getNormal(dynamicParentsConfiguration);
                normal1.setConditioningVariables(multinomialParents);
                normal1.setVar(staticVariable);
                ((Normal_MultinomialParents)staticVarConDist).setNormal(m, normal1);
                continue;
            }
            if (distributionType == 3) {
                Normal_MultinomialNormalParents normal_multinomialNormalParents = (Normal_MultinomialNormalParents)dynamicConditionalDistribution;
                ConditionalLinearGaussian clg = normal_multinomialNormalParents.getNormal_NormalParentsDistribution(dynamicParentsConfiguration);
                clg.setConditioningVariables(continuousParents);
                clg.setVar(staticVariable);
                ((Normal_MultinomialNormalParents)staticVarConDist).setNormal_NormalParentsDistribution(m, clg);
                continue;
            }
            ConditionalLinearGaussian clg = (ConditionalLinearGaussian)dynamicConditionalDistribution;
            staticVarConDist = clg;
        }
        return staticVarConDist;
    }

    public static void main(String[] arguments) throws IOException, ClassNotFoundException {
        DynamicBayesianNetworkGenerator.setNumberOfContinuousVars(2);
        DynamicBayesianNetworkGenerator.setNumberOfDiscreteVars(10);
        DynamicBayesianNetworkGenerator.setNumberOfStates(2);
        DynamicBayesianNetworkGenerator.setNumberOfLinks(5);
        int nStatesClassVar = 2;
        DynamicBayesianNetwork dynamicBayesianNetwork = DynamicBayesianNetworkGenerator.generateDynamicNaiveBayes(new Random(50L), nStatesClassVar, true);
        DynamicMAPInference dynMAP = new DynamicMAPInference();
        dynMAP.setModel(dynamicBayesianNetwork);
        int nTimeSteps = 5;
        dynMAP.setNumberOfTimeSteps(nTimeSteps);
        int nMergedClassVars = 3;
        dynMAP.setNumberOfMergedClassVars(nMergedClassVars);
        Variable mapVariable = dynamicBayesianNetwork.getDynamicVariables().getVariableByName("ClassVar");
        dynMAP.setMAPvariable(mapVariable);
        System.out.println(dynamicBayesianNetwork.toString());
        dynMAP.computeMergedClassVarModels();
        dynMAP.runInference();
    }

    public static enum SearchAlgorithm {
        VMP,
        IS;

    }
}

