/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.BaseDistribution_MultinomialParents;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_BaseDistribution_MultinomialParents;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.List;
import java.util.Random;

public class Normal_MultinomialParents
extends ConditionalDistribution {
    private BaseDistribution_MultinomialParents<Normal> base;

    public Normal_MultinomialParents(BaseDistribution_MultinomialParents<Normal> base_) {
        this.base = base_;
        this.var = this.base.getVariable();
        this.parents = this.base.getConditioningVariables();
    }

    public Normal_MultinomialParents(Variable var1, List<Variable> parents1) {
        this.var = var1;
        this.parents = parents1;
        this.base = new BaseDistribution_MultinomialParents(var1, parents1);
    }

    public Normal getNormal(int position) {
        return this.base.getBaseDistribution(position);
    }

    @Override
    public void setVar(Variable var) {
        this.var = var;
        this.base.setVar(var);
    }

    @Override
    public void setConditioningVariables(List<Variable> parents) {
        this.parents = parents;
        this.base.setConditioningVariables(parents);
    }

    @Override
    public double[] getParameters() {
        return this.base.getParameters();
    }

    @Override
    public int getNumberOfParameters() {
        int n = 0;
        for (Normal dist : this.getNormalDistributions()) {
            n += dist.getNumberOfParameters();
        }
        return n;
    }

    public Normal getNormal(Assignment parentsAssignment) {
        int position = MultinomialIndex.getIndexFromVariableAssignment((List<Variable>)this.parents, parentsAssignment);
        return this.getNormal(position);
    }

    public void setNormal(int position, Normal normalDistribution) {
        this.base.setBaseDistribution(position, normalDistribution);
    }

    public void setNormal(Assignment parentsAssignment, Normal normalDistribution) {
        int position = MultinomialIndex.getIndexFromVariableAssignment((List<Variable>)this.parents, parentsAssignment);
        this.setNormal(position, normalDistribution);
    }

    @Override
    public double getLogConditionalProbability(Assignment assignment) {
        double value = assignment.getValue(this.var);
        return this.getNormal(assignment).getLogProbability(value);
    }

    @Override
    public UnivariateDistribution getUnivariateDistribution(Assignment assignment) {
        return this.getNormal(assignment);
    }

    @Override
    public String label() {
        if (this.getNormalDistributions().size() == 1) {
            return "Normal";
        }
        return "Normal|Multinomial";
    }

    @Override
    public void randomInitialization(Random random) {
        for (int i = 0; i < this.getNumberOfParentAssignments(); ++i) {
            this.base.getBaseDistribution(i).randomInitialization(random);
        }
    }

    public List<Normal> getNormalDistributions() {
        return this.base.getBaseDistributions();
    }

    public int getNumberOfParentAssignments() {
        return this.getNormalDistributions().size();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("");
        for (int i = 0; i < this.getNumberOfParentAssignments(); ++i) {
            Assignment parentAssignment = MultinomialIndex.getVariableAssignmentFromIndex(this.getConditioningVariables(), i);
            str.append(this.getNormal(i).toString() + " | " + parentAssignment.outputString() + "\n");
        }
        return str.toString();
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof Normal_MultinomialParents) {
            return this.equalDist((Normal_MultinomialParents)dist, threshold);
        }
        return false;
    }

    public boolean equalDist(Normal_MultinomialParents dist, double threshold) {
        boolean equals = true;
        for (int i = 0; i < this.getNormalDistributions().size(); ++i) {
            equals = equals && this.getNormal(i).equalDist(dist.getNormal(i), threshold);
        }
        return equals;
    }

    public EF_BaseDistribution_MultinomialParents<EF_Normal> toEFConditionalDistribution() {
        return this.base.toEFConditionalDistribution();
    }
}

