/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataInstanceFromDataRow;
import eu.amidst.core.datastream.filereaders.DataRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class DataOnMemoryFromFile
implements DataOnMemory<DataInstance> {
    private DataFileReader reader;
    private DataInstanceFromDataRow[] dataInstances;

    public DataOnMemoryFromFile(DataFileReader reader) {
        this.reader = reader;
        ArrayList<DataInstanceFromDataRow> dataInstancesList = new ArrayList<DataInstanceFromDataRow>();
        for (DataRow row : reader) {
            dataInstancesList.add(new DataInstanceFromDataRow(row));
        }
        reader.restart();
        this.dataInstances = new DataInstanceFromDataRow[dataInstancesList.size()];
        int counter = 0;
        Iterator iterator = dataInstancesList.iterator();
        while (iterator.hasNext()) {
            DataInstanceFromDataRow inst;
            this.dataInstances[counter] = inst = (DataInstanceFromDataRow)iterator.next();
            ++counter;
        }
    }

    @Override
    public int getNumberOfDataInstances() {
        return this.dataInstances.length;
    }

    @Override
    public DataInstance getDataInstance(int i) {
        return this.dataInstances[i];
    }

    @Override
    public List<DataInstance> getList() {
        return Arrays.asList(this.dataInstances);
    }

    @Override
    public Attributes getAttributes() {
        return this.reader.getAttributes();
    }

    @Override
    public Stream<DataInstance> stream() {
        return Arrays.stream(this.dataInstances);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
    }
}

