/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.SparseFiniteStateSpace;
import java.io.Serializable;

public final class Attribute
implements Serializable {
    private static final long serialVersionUID = -2932037991574118651L;
    private final int index;
    private final String name;
    private final StateSpaceType stateSpaceType;
    private boolean specialAttribute = false;
    private boolean seq_id = false;
    private boolean time_id = false;

    public Attribute(int index, String name, StateSpaceType stateSpaceType1) {
        this.index = index;
        this.name = name;
        this.stateSpaceType = stateSpaceType1;
    }

    public boolean isSpecialAttribute() {
        return this.specialAttribute;
    }

    public void setSpecialAttribute(boolean specialAttribute) {
        this.specialAttribute = specialAttribute;
    }

    public boolean isSeqId() {
        return this.seq_id;
    }

    public void setSeqId(boolean seq_id) {
        this.seq_id = seq_id;
    }

    public boolean isTimeId() {
        return this.time_id;
    }

    public void setTimeId(boolean time_id) {
        this.time_id = time_id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public <E extends StateSpaceType> E getStateSpaceType() {
        return (E)this.stateSpaceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.stateSpaceType.getStateSpaceTypeEnum() != attribute.stateSpaceType.getStateSpaceTypeEnum()) {
            return false;
        }
        return this.name.equals(attribute.name);
    }

    public String stringValue(double value) {
        return ((StateSpaceType)this.getStateSpaceType()).stringValue(value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.stateSpaceType.hashCode();
        return result;
    }

    public int getNumberOfStates() {
        if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
            return ((FiniteStateSpace)this.getStateSpaceType()).getNumberOfStates();
        }
        if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.SPARSE_FINITE_SET) {
            return ((SparseFiniteStateSpace)this.getStateSpaceType()).getNumberOfStates();
        }
        return -1;
    }
}

