/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.conceptdrift;

import eu.amidst.core.conceptdrift.utils.GaussianHiddenTransitionMethod;
import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.learning.parametric.bayesian.SVB;
import eu.amidst.core.learning.parametric.bayesian.utils.PlateuIIDReplication;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.models.DAG;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import java.util.ArrayList;
import java.util.List;

public class NaiveBayesVirtualConceptDriftDetector {
    DataStream<DataInstance> data;
    int windowsSize;
    double transitionVariance;
    int classIndex = -1;
    DriftDetector conceptDriftDetector = DriftDetector.GLOBAL;
    int seed = 0;
    SVB svb;
    List<Variable> hiddenVars;
    double fading = 1.0;
    int numberOfGlobalVars = 1;
    boolean globalHidden = true;

    public Variable getClassVariable() {
        return this.svb.getLearntBayesianNetwork().getVariables().getVariableById(this.classIndex);
    }

    public void setNumberOfGlobalVars(int numberOfGlobalVars) {
        this.numberOfGlobalVars = numberOfGlobalVars;
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public void setData(DataStream<DataInstance> data) {
        this.data = data;
    }

    public void setWindowsSize(int windowsSize) {
        this.windowsSize = windowsSize;
    }

    public void setTransitionVariance(double transitionVariance) {
        this.transitionVariance = transitionVariance;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public SVB getSvb() {
        return this.svb;
    }

    public void deactivateTransitionMethod() {
        this.svb.setTransitionMethod(null);
    }

    public void activateTransitionMethod() {
        GaussianHiddenTransitionMethod gaussianHiddenTransitionMethod = new GaussianHiddenTransitionMethod(this.hiddenVars, 0.0, this.transitionVariance);
        gaussianHiddenTransitionMethod.setFading(this.fading);
        this.svb.setTransitionMethod(gaussianHiddenTransitionMethod);
    }

    private void buildGlobalDAG() {
        Variables variables = new Variables(this.data.getAttributes());
        String className = this.data.getAttributes().getFullListOfAttributes().get(this.classIndex).getName();
        this.hiddenVars = new ArrayList<Variable>();
        for (int i = 0; i < this.numberOfGlobalVars; ++i) {
            this.hiddenVars.add(variables.newGaussianVariable("GlobalHidden_" + i));
        }
        Variable classVariable = variables.getVariableByName(className);
        DAG dag = new DAG(variables);
        for (Attribute att : this.data.getAttributes().getListOfNonSpecialAttributes()) {
            if (att.getName().equals(className)) continue;
            Variable variable = variables.getVariableByName(att.getName());
            dag.getParentSet(variable).addParent(classVariable);
            if (!this.globalHidden) continue;
            for (int i = 0; i < this.numberOfGlobalVars; ++i) {
                dag.getParentSet(variable).addParent(this.hiddenVars.get(i));
            }
        }
        this.svb = new SVB();
        this.svb.setSeed(this.seed);
        this.svb.setPlateuStructure(new PlateuIIDReplication(this.hiddenVars));
        GaussianHiddenTransitionMethod gaussianHiddenTransitionMethod = new GaussianHiddenTransitionMethod(this.hiddenVars, 0.0, this.transitionVariance);
        gaussianHiddenTransitionMethod.setFading(this.fading);
        this.svb.setTransitionMethod(gaussianHiddenTransitionMethod);
        this.svb.setWindowsSize(this.windowsSize);
        this.svb.setDAG(dag);
        this.svb.setOutput(false);
        this.svb.getPlateuStructure().getVMP().setMaxIter(1000);
        this.svb.getPlateuStructure().getVMP().setThreshold(0.001);
        this.svb.initLearning();
    }

    public void initLearning() {
        if (this.classIndex == -1) {
            this.classIndex = this.data.getAttributes().getNumberOfAttributes() - 1;
        }
        switch (this.conceptDriftDetector) {
            case GLOBAL: {
                this.buildGlobalDAG();
            }
        }
    }

    public double[] updateModel(DataOnMemory<DataInstance> batch) {
        this.svb.updateModel(batch);
        double[] out = new double[this.hiddenVars.size()];
        for (int i = 0; i < out.length; ++i) {
            Variable hiddenVar = this.hiddenVars.get(i);
            Normal normal = (Normal)this.svb.getParameterPosterior(hiddenVar);
            out[i] = normal.getMean();
        }
        return out;
    }

    public List<Variable> getHiddenVars() {
        return this.hiddenVars;
    }

    public BayesianNetwork getLearntBayesianNetwork() {
        return this.svb.getLearntBayesianNetwork();
    }

    public static enum DriftDetector {
        GLOBAL;

    }
}

