% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instruments.R
\docType{class}
\name{EuropeanOption-class}
\alias{EuropeanOption}
\alias{EuropeanOption-class}
\title{A standard option contract}
\description{
At maturity, the call option holder will "exercise", i.e. choose stock, with value \code{S}, if the
stock price is above the strike \code{K}, paying \code{K} to the option issuer,
realizing value \code{S-K}.  The put option holder will exercise, receiving \code{K} while surrendering
stock worth \code{S}, if the stock price is below \code{K}.
}
\details{
Therefore the value at maturity is equal to \code{max(0,callput*(S-K))}
}
\section{Methods}{

\describe{
\item{\code{optionality_fcn(v, ...)}}{Return a version of {v} at time {t} corrected for any optionality conditions.}

\item{\code{recovery_fcn(v, S, t, ...)}}{Return recovery value, given non-default values {v} at time {t}.  Subclasses may be more elaborate, this method simply returns 0.0.}
}}

