% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_jpeg}
\alias{agg_jpeg}
\title{Draw to a JPEG file}
\usage{
agg_jpeg(
  filename = "Rplot\%03d.jpeg",
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  quality = 75,
  smoothing = FALSE,
  method = "slow",
  bg
)
}
\arguments{
\item{filename}{The name of the file. Follows the same semantics as the file 
naming in [grDevices::png()], meaning that you can provide a [sprintf()] 
compliant string format to name multiple plots (such as the default value)}

\item{width}{The dimensions of the device}

\item{height}{The dimensions of the device}

\item{units}{The unit `width` and `height` is measured in, in either pixels 
(`'px'`), inches (`'in'`), millimeters (`'mm'`), or centimeter (`'cm'`).}

\item{pointsize}{The default pointsize of the device in pt}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{quality}{An integer between `0` and `100` defining the quality/size 
tradeoff. Setting this to `100` will result in no compression.}

\item{smoothing}{A smoothing factor to apply before compression, from `0` (no
smoothing) to `100` (full smoothing). Can also by `FALSE` (no smoothing) or 
`TRUE` (full smoothing).}

\item{method}{The compression algorithm to use. Either `'slow'`, `'fast'`, or
`'float'`. Default is `'slow'` which works best for most cases. `'fast'` 
should only be used when quality is below `97` as it may result in worse 
performance at high quality settings. `'float'` is a legacy options that 
calculate the compression using floating point precission instead of with 
integers. It offers no quality benefit and is often much slower.}

\item{bg}{Same as `background` for compatibility with old graphic device APIs}
}
\description{
The JPEG file format is a lossy compressed file format developed in 
particular for digital photography. The format is not particularly 
well-suited for line drawings and text of the type normally associated with 
statistical plots as the compression algorithm creates noticable artefacts. 
It is, however, great for saving image data, e.g. heightmaps etc. Thus, for
standard plots, it would be better to use [agg_png()], but for plots that
includes a high degree of raster image rendering this device will result in
smaller plots with very little quality degradation.
}
\note{
Smoothing is only applied if ragg has been compiled against a jpeg 
library that supports smoothing.
}
\examples{
file <- tempfile(fileext = '.jpeg')
agg_jpeg(file, quality = 50)
plot(sin, -pi, 2*pi)
dev.off()

}
