% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratemeter_sim.R
\name{rate_meter_sim}
\alias{rate_meter_sim}
\title{Ratemeter Simulation}
\usage{
rate_meter_sim(cpm_equilibrium, meter_scale_increments, trials = 600,
  tau = 9.5, log_opt = "")
}
\arguments{
\item{cpm_equilibrium}{The expected count rate.}

\item{meter_scale_increments}{The meter scale increments.}

\item{trials}{Number of seconds to run simulation. Default = 600.}

\item{tau}{equal to the Resistance * Capacitance of the counting circuit.
Units = seconds. Default set to 9.5, which provides 90% equilibrium in 22
seconds. If the user does not know the time constant, but has an estimate
of equilibrium in some time, use tau.estimate.}

\item{log_opt}{If logarithmic scale is needed, set to "y". If set to anything
but blank (default), scale will be logarithmic.}
}
\value{
Plot of simulated meter reading every second..
}
\description{
Plot simulated ratemeter readings once per second for 600
  seconds. The meter starts with a reading of zero and builds up based on the
  time constant. Resolution uncertainty is established to express the
  uncertainty from reading an analog scale, including the instability of its
  readings. Many standard references identify the precision or resolution
  uncertainty of analog readings as half of the smallest increment. This
  should be considered the single coverage uncertainty for a very stable
  reading. When a reading is not very stable, evaluation of the reading
  fluctuation is evaluated in terms of numbers of scale increments covered by
  meter indication over a reasonable evaluation period.
}
\examples{
rate_meter_sim(cpm_equilibrium = 270, meter_scale_increments = seq(100, 1000, 20))
rate_meter_sim(cpm_equilibrium = 2.7e5, meter_scale_increments = seq(2e5, 1e6, 2e4))
rate_meter_sim(450, seq(20, 1000, 20), trials = 1200, tau = 24.8534)
}
\concept{rad_measurements}
