% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk_to_disk_solid_angle.R
\name{disk_to_disk_solid_angle}
\alias{disk_to_disk_solid_angle}
\title{Calculate fractional solid angle for disk to disk}
\usage{
disk_to_disk_solid_angle(r.source, gap, r.detector, plot.opt,
  runs = 10000)
}
\arguments{
\item{r.source}{source radius (all units must be consistent)}

\item{gap}{distance between source and detector}

\item{r.detector}{detector radius}

\item{plot.opt}{plot options - "2d", "3d" or "n".}

\item{runs}{Number of particles to simulate. Running more particles improves
accuracy. Default = 1e4.}
}
\value{
Fractional solid angle and plot of simulation.
}
\description{
Returns fractional solid angle for a geometry frequently
  encountered in health physics analysis of air samples or disk smears. This
  is useful in correcting configurations that do not exactly match
  calibration (by ratioing the respective fractional solid angles). While
  units of steridian are used for solid angle, this function only uses a
  fraction of the total field of view.
}
\examples{
disk_to_disk_solid_angle(r.source = 50, gap = 20, r.detector = 60, plot.opt = "2d")
disk_to_disk_solid_angle(r.source = 50, gap = 20, r.detector = 60,
runs = 1e3, plot.opt = "3d")
disk_to_disk_solid_angle(r.source = 15, gap = 20,
r.detector = 10, plot.opt = "n")
}
