% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radjust.R
\docType{data}
\name{crohn}
\alias{crohn}
\title{p-values of 126 SNPs followed from a primary study to a follow-up study for testing their association
with Crohn's disease.}
\format{A data frame with 126 rows and 3 columns:
\tabular{lll}{
\code{index} \tab integer \tab just the row number. \cr
\code{pv1}   \tab numeric \tab p-value from study 1. \cr
\code{pv2}   \tab numeric \tab p-value from study 2.
}}
\source{
Barrett, Jeffrey C., et al. "Genome-wide association defines more than 30 distinct susceptibility loci for
 Crohn's disease." Nature genetics 40.8 (2008): 955.
}
\usage{
crohn
}
\description{
To discover the associations between SNPs and Crohn's disease, 635547 SNPs were examined in a primary study. For follow-up, 126 SNPs were measured in an independent study.
The criteria for follow-up were as follows: the two smallest p-values in each distinct region with primary study p-values below 0.00005.
}
\references{
Bogomolov, M. and Heller, R. (2013). Discovering findings that replicate from a primary study of high dimension to a follow-up study.
Journal of the American Statistical Association, Vol. 108, No. 504, Pp. 1480-1492.
}
\seealso{
the example in \code{\link{radjust_pf}} uses this data.
}
\keyword{datasets}
