% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmap.R
\name{plot.pmap}
\alias{plot.pmap}
\title{Plot method for the pmap function}
\usage{
\method{plot}{pmap}(x, plots = "", scaling = 2.1, fontsz = 1.3, ...)
}
\arguments{
\item{x}{Return value from \code{\link{pmap}}}

\item{plots}{Components to include in the plot ("brand", "attr"). If data on preferences is available use "pref" to add preference arrows to the plot}

\item{scaling}{Arrow scaling in the brand map}

\item{fontsz}{Font size to use in plots}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the pmap function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer", "brand", "high_end:business")
plot(result, plots = "brand")
plot(result, plots = c("brand", "attr"))
plot(result, plots = c("brand", "attr"))
plot(result, scaling = 1, plots = c("brand", "attr"))
result <- pmap("computer", "brand", "high_end:dated",
               pref = c("innovative", "business"))
plot(result, plots = c("brand", "attr", "pref"))

}
\seealso{
\code{\link{pmap}} to calculate results

\code{\link{summary.pmap}} to plot results
}

