% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{regress}
\alias{regress}
\title{Linear regression using OLS}
\usage{
regress(
  dataset,
  rvar,
  evar,
  int = "",
  check = "",
  form,
  data_filter = "",
  arr = "",
  rows = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{rvar}{The response variable in the regression}

\item{evar}{Explanatory variables in the regression}

\item{int}{Interaction terms to include in the model}

\item{check}{Use "standardize" to see standardized coefficient estimates. Use "stepwise-backward" (or "stepwise-forward", or "stepwise-both") to apply step-wise selection of variables in estimation. Add "robust" for robust estimation of standard errors (HC1)}

\item{form}{Optional formula to use instead of rvar, evar, and int}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{arr}{Expression to arrange (sort) the data on (e.g., "color, desc(price)")}

\item{rows}{Rows to select from the specified dataset}

\item{envir}{Environment to extract data from}
}
\value{
A list of all variables used in the regress function as an object of class regress
}
\description{
Linear regression using OLS
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/regress.html} for an example in Radiant
}
\examples{
regress(diamonds, "price", c("carat", "clarity"), check = "standardize") \%>\% summary()
regress(diamonds, "price", c("carat", "clarity")) \%>\% str()

}
\seealso{
\code{\link{summary.regress}} to summarize results

\code{\link{plot.regress}} to plot results

\code{\link{predict.regress}} to generate predictions
}
