% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalbin.R
\name{rig}
\alias{rig}
\title{Relative Information Gain (RIG)}
\usage{
rig(pred, rvar, lev, crv = 1e-07, na.rm = TRUE)
}
\arguments{
\item{pred}{Prediction or predictor}

\item{rvar}{Response variable}

\item{lev}{The level in the response variable defined as success}

\item{crv}{Correction value to avoid log(0)}

\item{na.rm}{Logical that indicates if missing values should be removed (TRUE) or not (FALSE)}
}
\value{
RIG statistic
}
\description{
Relative Information Gain (RIG)
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/evalbin.html} for an example in Radiant
}
\examples{
rig(runif(20000), dvd$buy, "yes")
rig(ifelse(dvd$buy == "yes", 1, 0), dvd$buy, "yes")
}
\seealso{
\code{\link{evalbin}} to calculate results

\code{\link{summary.evalbin}} to summarize results

\code{\link{plot.evalbin}} to plot results
}
