% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doe.R
\name{doe}
\alias{doe}
\title{Create (partial) factorial design}
\usage{
doe(factors, int = "", trials = NA, seed = NA)
}
\arguments{
\item{factors}{Categorical variables used as input for design}

\item{int}{Vector of interaction terms to consider when generating design}

\item{trials}{Number of trials to create. If NA then all feasible designs will be considered until a design with perfect D-efficiency is found}

\item{seed}{Random seed to use as the starting point}
}
\value{
A list with all variables defined in the function as an object of class doe
}
\description{
Create (partial) factorial design
}
\details{
See \url{https://radiant-rstats.github.io/docs/design/doe.html} for an example in Radiant
}
\examples{
doe(c("price; $10; $13; $16", "food; popcorn; gourmet; no food"))
doe(
  c("price; $10; $13; $16", "food; popcorn; gourmet; no food"),
  int = "price:food", trials = 9, seed = 1234
)

}
\seealso{
\code{\link{summary.doe}} to summarize results
}
