% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{show_duplicated}
\alias{show_duplicated}
\title{Show all rows with duplicated values (not just the first or last)}
\usage{
show_duplicated(.tbl, ...)
}
\arguments{
\item{.tbl}{Data frame to add transformed variables to}

\item{...}{Variables used to evaluate row uniqueness}
}
\description{
Show all rows with duplicated values (not just the first or last)
}
\details{
If an entire row is duplicated use "duplicated" to show only one of the duplicated rows. When using a subset of variables to establish uniqueness it may be of interest to show all rows that have (some) duplicate elements
}
\examples{
bind_rows(mtcars, mtcars[c(1,5,7),]) \%>\%
  show_duplicated(mpg, cyl)
bind_rows(mtcars, mtcars[c(1,5,7),]) \%>\%
  show_duplicated

}
