% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_quarto.R
\name{write_quarto}
\alias{write_quarto}
\title{Create a New Quarto Document}
\usage{
write_quarto(filename = NULL, path = here(), example = NULL)
}
\arguments{
\item{filename}{Character string. The name of the file without the '.qmd' extension.
Only letters, numbers, hyphens, and underscores are allowed.}

\item{path}{Character string. Directory where the file will be created. Defaults to
the current project's base directory.}

\item{example}{Logical. Will the analysis file include a paper example with table/
figure? Default is \code{NULL} and will use a default, non-paper template. If this is set
to \code{TRUE}, then it will use the Quarto paper template with examples of a table and
figure with cross-referencing. If this is \code{FALSE}, then it will use the Quarto paper
template without examples for tables.}
}
\value{
Opens file after creating the Quarto document.
}
\description{
This function creates a new Quarto document (.qmd file) complete with a useful header.
}
\examples{
\dontrun{
# Create a new Quarto document
write_quarto(filename = "data_cleaning", path = tempdir())
}
}
