\name{hosvd}
\alias{hosvd}
\title{(Truncated-)Higher-order SVD}
\usage{
  hosvd(tnsr, ranks = NULL)
}
\arguments{
  \item{tnsr}{Tensor with K modes}

  \item{ranks}{a vector of desired modes in the output core
  tensor, default is \code{getModes(tnsr)}}
}
\value{
  a list containing the following:\describe{
  \item{\code{Z}}{core tensor with modes speficied by
  \code{ranks}} \item{\code{U}}{a list of orthogonal
  matrices, one for each mode} \item{\code{resid}}{the
  relative error in Frobenius norm - if there was no
  truncation, then this is O(mach_eps). } }
}
\description{
  Higher-order SVD of a K-Tensor. Write the K-Tensor as a
  (m-mode) product of a core Tensor (possibly smaller
  modes) and K orthogonal factor matrices. Truncations can
  be specified via \code{ranks} (making them smaller than
  the original modes of the K-Tensor will result in a
  truncation). For the mathematical details on HOSVD,
  consult Lathauwer et. al. (2000).
}
\details{
  Uses the Alternating Least Squares (ALS) estimation
  procedure. A progress bar is included to help monitor
  operations on large tensors.
}
\note{
  The length of \code{ranks} must match
  \code{getNumModes(tnsr)}.
}
\examples{
tnsr <- new("Tensor",3L,c(6L,7L,8L),data=runif(336))
hosvdD <-hosvd(tnsr)
hosvdD$resid
hosvdD2 <-hosvd(tnsr,ranks=c(3,3,4))
hosvdD2$resid
}
\references{
  L. Lathauwer, B.Moor, J. Vanderwalle "A multilinear
  singular value decomposition". Journal of Matrix Analysis
  and Applications 2000.
}
\seealso{
  \code{\link{tucker}}
}

