/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.ThreadState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyReflectedConstructor
extends PyReflectedFunction {
    public PyReflectedConstructor(String name) {
        super(name);
        this.__name__ = name;
        this.argslist = new ReflectedArgs[1];
        this.nargs = 0;
    }

    public PyReflectedConstructor(Constructor c) {
        this(c.getDeclaringClass().getName());
        this.addConstructor(c);
    }

    private ReflectedArgs makeArgs(Constructor m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), true);
    }

    public void addConstructor(Constructor m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && Options.respectJavaAccessibility) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    PyObject make(PyObject[] args, String[] keywords) {
        ReflectedArgs[] argsl = this.argslist;
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        boolean consumes_keywords = false;
        int nkeywords = keywords.length;
        PyObject[] allArgs = null;
        if (this.nargs > 0) {
            if (argsl[0].matches(null, args, keywords, callData)) {
                method = argsl[0].data;
                consumes_keywords = argsl[0].flags == 2;
            } else {
                allArgs = args;
                int i = 1;
                if (nkeywords > 0) {
                    args = new PyObject[allArgs.length - nkeywords];
                    System.arraycopy(allArgs, 0, args, 0, args.length);
                    i = 0;
                }
                while (i < this.nargs) {
                    ReflectedArgs rargs = argsl[i];
                    if (rargs.matches(null, args, Py.NoKeywords, callData)) {
                        method = rargs.data;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, true, false);
        }
        PyObject obj = null;
        try {
            obj = (PyObject)((Constructor)method).newInstance(callData.getArgsArray());
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
        if (!consumes_keywords) {
            int offset = args.length;
            for (int i = 0; i < nkeywords; ++i) {
                obj.__setattr__(keywords[i], allArgs[i + offset]);
            }
        }
        return obj;
    }

    @Override
    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        if (self == null) {
            throw Py.TypeError("invalid self argument to constructor");
        }
        Class declaringClass = this.argslist[0].declaringClass;
        Class<?> javaClass = self instanceof PyInstance ? ((PyInstance)self).instclass.proxyClass : self.getType().underlying_class;
        if (!declaringClass.isAssignableFrom(javaClass)) {
            throw Py.TypeError("self invalid - must implement: " + declaringClass.getName());
        }
        if (!PyProxy.class.isAssignableFrom(declaringClass) && !(self instanceof PyJavaInstance)) {
            PyJavaClass jc = PyJavaClass.lookup(javaClass);
            jc.initConstructors();
            return jc.__init__.__call__(self, args, keywords);
        }
        if (self.javaProxy != null) {
            Class<?> sup = javaClass;
            if (PyProxy.class.isAssignableFrom(sup)) {
                sup = sup.getSuperclass();
            }
            throw Py.TypeError("instance already instantiated for " + sup.getName());
        }
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        int nkeywords = keywords.length;
        PyObject[] allArgs = args;
        if (nkeywords > 0) {
            args = new PyObject[allArgs.length - nkeywords];
            System.arraycopy(allArgs, 0, args, 0, args.length);
        }
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = this.argslist[i];
            if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
            method = rargs.data;
            break;
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, false, false);
        }
        this.constructProxy(self, (Constructor)method, callData.getArgsArray(), javaClass);
        int offset = args.length;
        for (int i = 0; i < nkeywords; ++i) {
            self.__setattr__(keywords[i], allArgs[i + offset]);
        }
        return Py.None;
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args.length < 1) {
            throw Py.TypeError("constructor requires self argument");
        }
        PyObject[] newArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.__call__(args[0], newArgs, keywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructProxy(PyObject obj, Constructor<?> ctor, Object[] args, Class<?> proxy) {
        Object jself = null;
        ThreadState ts = Py.getThreadState();
        try {
            if (obj instanceof PyInstance) {
                ts.pushInitializingProxy((PyInstance)obj);
            }
            try {
                jself = ctor.newInstance(args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InstantiationException) {
                    Class<?> sup = proxy.getSuperclass();
                    String msg = "Constructor failed for Java superclass";
                    if (sup != null) {
                        msg = msg + " " + sup.getName();
                    }
                    throw Py.TypeError(msg);
                }
                throw Py.JavaError(e);
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
        }
        finally {
            if (obj instanceof PyInstance) {
                ts.popInitializingProxy();
            }
        }
        obj.javaProxy = jself;
    }

    @Override
    public String toString() {
        return "<java constructor " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

