/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Hashtable;
import java.util.Stack;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.argumentsType;
import org.python.antlr.ast.exprType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.stmtType;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.ParserFacade;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private Stack scopes;
    private ScopeInfo cur = null;
    private Hashtable nodeScopes;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext code_compiler, Hashtable nodeScopes) {
        this.code_compiler = code_compiler;
        this.nodeScopes = nodeScopes;
        this.scopes = new Stack();
    }

    public void beginScope(String name, int kind, PythonTree node, ArgListCompiler ac) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (kind == 1) {
            ++this.func_level;
        }
        this.cur = new ScopeInfo(name, node, this.level++, kind, this.func_level, ac);
        this.nodeScopes.put(node, this.cur);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo up = null;
        if (!this.scopes.empty()) {
            up = (ScopeInfo)this.scopes.pop();
        }
        int dist = 1;
        ScopeInfo referenceable = up;
        int i = this.scopes.size() - 1;
        while (i >= 0 && referenceable.kind == 2) {
            referenceable = (ScopeInfo)this.scopes.get(i);
            --i;
            ++dist;
        }
        this.cur.cook(referenceable, dist, this.code_compiler);
        this.cur.dump();
        this.cur = up;
    }

    public void parse(PythonTree node) throws Exception {
        try {
            this.visit(node);
        }
        catch (Throwable t) {
            throw ParserFacade.fixParseError(null, t, this.code_compiler.getFilename());
        }
    }

    public Object visitInteractive(Interactive node) throws Exception {
        this.beginScope("<single-top>", 0, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.beginScope("<file-top>", 0, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitExpression(Expression node) throws Exception {
        this.beginScope("<eval-top>", 0, node, null);
        this.visit(new Return(node, node.body));
        this.endScope();
        return null;
    }

    private void def(String name) {
        this.cur.addBound(name);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        int i;
        this.def(node.name);
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.args);
        exprType[] defaults = ac.getDefaults();
        for (int i2 = 0; i2 < defaults.length; ++i2) {
            this.visit(defaults[i2]);
        }
        exprType[] decs = node.decorators;
        for (int i3 = decs.length - 1; i3 >= 0; --i3) {
            this.visit(decs[i3]);
        }
        this.beginScope(node.name, 1, node, ac);
        int n = ac.names.size();
        for (i = 0; i < n; ++i) {
            this.cur.addParam((String)ac.names.elementAt(i));
        }
        for (i = 0; i < ac.init_code.size(); ++i) {
            this.visit((stmtType)ac.init_code.elementAt(i));
        }
        this.cur.markFromParam();
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(node.args);
        exprType[] defaults = ac.getDefaults();
        for (int i = 0; i < defaults.length; ++i) {
            this.visit(defaults[i]);
        }
        this.beginScope("<lambda>", 1, node, ac);
        for (Object o : ac.names) {
            this.cur.addParam((String)o);
        }
        for (Object o : ac.init_code) {
            this.visit((stmtType)o);
        }
        this.cur.markFromParam();
        this.visit(node.body);
        this.endScope();
        return null;
    }

    public void suite(stmtType[] stmts) throws Exception {
        for (int i = 0; i < stmts.length; ++i) {
            this.visit(stmts[i]);
        }
    }

    public Object visitImport(Import node) throws Exception {
        for (int i = 0; i < node.names.length; ++i) {
            if (node.names[i].asname != null) {
                this.cur.addBound(node.names[i].asname);
                continue;
            }
            String name = node.names[i].name;
            if (name.indexOf(46) > 0) {
                name = name.substring(0, name.indexOf(46));
            }
            this.cur.addBound(name);
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        Future.checkFromFuture(node);
        int n = node.names.length;
        if (n == 0) {
            this.cur.from_import_star = true;
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (node.names[i].asname != null) {
                this.cur.addBound(node.names[i].asname);
                continue;
            }
            this.cur.addBound(node.names[i].name);
        }
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        for (String name : node.names) {
            int prev = this.cur.addGlobal(name);
            if (prev < 0) continue;
            if ((prev & 8) != 0) {
                this.code_compiler.error("name '" + name + "' is local and global", true, node);
            }
            if ((prev & 0x42) != 0) continue;
            String what = (prev & 1) != 0 ? "assignment" : "use";
            this.code_compiler.error("name '" + name + "' declared global after " + what, false, node);
        }
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        this.cur.exec = true;
        if (node.globals == null && node.locals == null) {
            this.cur.unqual_exec = true;
        }
        this.traverse(node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.def(node.name);
        int n = node.bases.length;
        for (int i = 0; i < n; ++i) {
            this.visit(node.bases[i]);
        }
        this.beginScope(node.name, 2, node, null);
        this.suite(node.body);
        this.endScope();
        return null;
    }

    public Object visitName(Name node) throws Exception {
        String name = node.id;
        if (node.ctx != expr_contextType.Load) {
            if (name.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", true, node);
            }
            this.cur.addBound(name);
        } else {
            this.cur.addUsed(name);
        }
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        String tmp = "_[" + node.getLine() + "_" + node.getCharPositionInLine() + "]";
        this.cur.addBound(tmp);
        this.traverse(node);
        return null;
    }

    public Object visitYield(Yield node) throws Exception {
        this.cur.defineAsGenerator(node);
        ++this.cur.yield_count;
        this.traverse(node);
        return null;
    }

    public Object visitReturn(Return node) throws Exception {
        if (node.value != null) {
            this.cur.noteReturnValue(node);
        }
        this.traverse(node);
        return null;
    }

    public Object visitGeneratorExp(GeneratorExp node) throws Exception {
        if (node.generators != null && node.generators.length > 0) {
            this.visit(node.generators[0].iter);
        }
        String bound_exp = "_(x)";
        String tmp = "_(" + node.getLine() + "_" + node.getCharPositionInLine() + ")";
        this.def(tmp);
        ArgListCompiler ac = new ArgListCompiler();
        ac.visitArgs(new argumentsType(node, new exprType[]{new Name(node.token, bound_exp, expr_contextType.Param)}, null, null, new exprType[0]));
        this.beginScope(tmp, 1, node, ac);
        this.cur.addParam(bound_exp);
        this.cur.markFromParam();
        this.cur.defineAsGenerator(node);
        ++this.cur.yield_count;
        if (node.elt != null) {
            this.visit(node.elt);
        }
        if (node.generators != null) {
            for (int i = 0; i < node.generators.length; ++i) {
                if (node.generators[i] == null) continue;
                if (i == 0) {
                    this.visit(node.generators[i].target);
                    if (node.generators[i].ifs == null) continue;
                    for (exprType cond : node.generators[i].ifs) {
                        if (cond == null) continue;
                        this.visit(cond);
                    }
                    continue;
                }
                this.visit(node.generators[i]);
            }
        }
        this.endScope();
        return null;
    }

    public Object visitWith(With node) throws Exception {
        ++this.cur.max_with_count;
        this.traverse(node);
        return null;
    }
}

