/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFind;
import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.MainProcessor;
import com.tonicsystems.jarjar.RulesFileParser;
import com.tonicsystems.jarjar.StringDumper;
import com.tonicsystems.jarjar.TextDepHandler;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import com.tonicsystems.jarjar.ext_util.StandaloneJarProcessor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class Main {
    private static final String HELP;
    private boolean verbose;
    private List patterns;
    private int level = 0;

    public static void main(String[] args) throws Exception {
        IoUtils.runMain(new Main(), args, "help");
    }

    public void help() {
        System.err.print(HELP);
    }

    public void strings(String cp) throws IOException {
        if (cp == null) {
            throw new IllegalArgumentException("cp is required");
        }
        new StringDumper().run(cp, new PrintWriter(System.out));
    }

    public void find(String level, String cp1, String cp2) throws IOException {
        int levelFlag;
        if (level == null || cp1 == null) {
            throw new IllegalArgumentException("level and cp1 are required");
        }
        if (cp2 == null) {
            cp2 = cp1;
        }
        if ("class".equals(level)) {
            levelFlag = 0;
        } else if ("jar".equals(level)) {
            levelFlag = 1;
        } else {
            throw new IllegalArgumentException("unknown level " + level);
        }
        PrintWriter w = new PrintWriter(System.out);
        TextDepHandler handler = new TextDepHandler(w, levelFlag);
        new DepFind().run(cp1, cp2, handler);
        w.flush();
    }

    public void process(File rulesFile, File inJar, File outJar) throws IOException {
        if (rulesFile == null || inJar == null || outJar == null) {
            throw new IllegalArgumentException("rulesFile, inJar, and outJar are required");
        }
        boolean verbose = false;
        List rules = RulesFileParser.parse(rulesFile);
        MainProcessor proc = new MainProcessor(rules, verbose, true);
        StandaloneJarProcessor.run(inJar, outJar, proc);
        proc.strip(outJar);
    }

    static {
        try {
            HELP = IoUtils.readIntoString(Main.class.getResourceAsStream("help.txt"));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

