% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde_anisotropic.R
\name{rspde.anistropic2d}
\alias{rspde.anistropic2d}
\title{Rational approximations of stationary anisotropic Gaussian Matern random fields}
\usage{
rspde.anistropic2d(
  mesh,
  nu = NULL,
  nu.upper.bound = 2,
  rspde.order = 1,
  prior.hx = NULL,
  prior.hy = NULL,
  prior.hxy = NULL,
  prior.sigma = NULL,
  prior.precision = NULL,
  prior.nu = NULL,
  prior.nu.dist = "lognormal",
  nu.prec.inc = 0.01,
  type.rational.approx = "chebfun",
  shared_lib = "detect",
  debug = FALSE,
  ...
)
}
\arguments{
\item{mesh}{Spatial mesh for the FEM approximation.}

\item{nu}{If nu is set to a parameter, nu will be kept fixed and will not
be estimated. If nu is \code{NULL}, it will be estimated.}

\item{nu.upper.bound}{Upper bound for the smoothness parameter \eqn{\nu}. If \code{NULL}, it will be set to 2.}

\item{rspde.order}{The order of the covariance-based rational SPDE approach. The default order is 1.}

\item{prior.hx}{A list specifying the prior for the parameter \eqn{h_x} in the matrix \eqn{H}. This list may contain two elements: \code{mean} and/or \code{precision}, both of which must be numeric scalars. The precision refers to the prior on \eqn{\log(h_x)}. If \code{NULL}, default values will be used. The \code{mean} value is also used as starting value for hx.}

\item{prior.hy}{A list specifying the prior for the parameter \eqn{h_y} in the matrix \eqn{H}. This list may contain two elements: \code{mean} and/or \code{precision}, both of which must be numeric scalars. The precision refers to the prior on \eqn{\log(h_x)}. If \code{NULL}, default values will be used. The \code{mean} value is also used as starting value for hy.}

\item{prior.hxy}{A list specifying the prior for the parameter \eqn{h_x} in the matrix \eqn{H}. This list may contain two elements: \code{mean} and/or \code{precision}, both of which must be numeric scalars. The precision refers to the prior on \eqn{\log((h_{xy}+1)/(1-h_{xy}))}. If \code{NULL}, default values will be used. The \code{mean} value is also used as starting value for hxy.}

\item{prior.sigma}{A list specifying the prior for the variance parameter \eqn{\sigma}.
This list may contain two elements: \code{mean} and/or \code{precision}, both of which must
be numeric scalars. The precision refers to the prior on \eqn{\log(\sigma)}. If \code{NULL},
default values will be used. The \code{mean} value is also used as starting value for sigma.}

\item{prior.precision}{A precision matrix for \eqn{\log(h_x), \log(h_y), \log((h_{xy}+1)/(1-h_{xy})), \log(\sigma)}. This matrix replaces the precision
element from \code{prior.kappa}, \code{prior.sigma}, \code{prior.gamma}, and \code{prior.rho} respectively. For dimension 1 \code{prior.precision} must be a 4x4 matrix. For dimension 2, \eqn{\rho} is a vector of length 2, so in this case \code{prior.precision} must be a 5x5 matrix. If \code{NULL}, a diagonal precision matrix with default values will be used.}

\item{prior.nu}{a list containing the elements \code{mean} and \code{prec}
for beta distribution, or \code{loglocation} and \code{logscale} for a
truncated lognormal distribution. \code{loglocation} stands for
the location parameter of the truncated lognormal distribution in the log
scale. \code{prec} stands for the precision of a beta distribution.
\code{logscale} stands for the scale of the truncated lognormal
distribution on the log scale. Check details below.}

\item{prior.nu.dist}{The distribution of the smoothness parameter.
The current options are "beta" or "lognormal". The default is "lognormal".}

\item{nu.prec.inc}{Amount to increase the precision in the beta prior
distribution. Check details below.}

\item{type.rational.approx}{Which type of rational approximation
should be used? The current types are "chebfun", "brasil" or "chebfunLB".}

\item{shared_lib}{String specifying which shared library to use for the Cgeneric
implementation. Options are "detect", "INLA", or "rSPDE". You may also specify the
direct path to a .so (or .dll) file.}

\item{debug}{Logical value indicating whether to enable INLA debug mode.}

\item{...}{Additional arguments passed internally for configuration purposes.}
}
\value{
An object of class \code{inla_rspde_spacetime} representing the FEM approximation of
the space-time Gaussian random field.
}
\description{
\code{rspde.anistropic2d} computes a Finite Element Method (FEM) approximation of a
Gaussian random field defined as the solution to the stochastic partial
differential equation (SPDE):
\deqn{C(h) = \frac{\sigma^2}{2^{\nu-1}\Gamma(\nu)}(\sqrt{h^T H^{-1}h})^\nu K_\nu(\sqrt{h^T H^{-1}h})},
based on a SPDE representation of the form
\deqn{(I - \nabla\cdot(H\nabla))^{(\nu+1)/2}u = c\sigma W},
where $c>0$ is a constant. The matrix \eqn{H} is defined as
\deqn{\begin{bmatrix}
h_x^2 & h_xh_yh_{xy} \\
h_xh_yh_{xy} & h_y^2
\end{bmatrix}}
}
