% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{logisticMap}
\alias{logisticMap}
\title{This is the discrete time logistic growth function known as the logistic map.  It calculates the amount of growth expected
in a step of time given by:  N_t+1 = N_t + r * (N_t (K - N_t)/K);
where N_t is community size at a time point, r is the per step growth rate, and K is the environmental carrying capacity.}
\usage{
logisticMap(func_rate, func_startPop, func_maxPop)
}
\arguments{
\item{func_rate}{Per time step intrinsic growth rate of individuals}

\item{func_startPop}{The initial summed size of the evolving community}

\item{func_maxPop}{The carrying capacity of the simulated environment}
}
\value{
A single value as to the expected summed size of evolving populations in the considered environment.
}
\description{
This is the discrete time logistic growth function known as the logistic map.  It calculates the amount of growth expected
in a step of time given by:  N_t+1 = N_t + r * (N_t (K - N_t)/K);
where N_t is community size at a time point, r is the per step growth rate, and K is the environmental carrying capacity.
}
\examples{
# This is the discrete time step form of the logistic equation, known as the logistic map.
# It takes a growth rate starting and max possible community size.
stepwise_Size <- 100
for(thisStep in 1:7){
  stepwise_Size <- c(stepwise_Size,
                     logisticMap(2,stepwise_Size[length(stepwise_Size)],1e4))
}
stepwise_Size
# When a population overshoots, it will loose members.
}
