% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/base-pref-macros.R
\name{base_pref_macros}
\alias{around}
\alias{base_pref_macros}
\alias{between}
\alias{layered}
\alias{pos}
\title{Useful base preference macros}
\usage{
around(expr, center)

between(expr, left, right)

pos(expr, pos_value)

layered(expr, ...)
}
\arguments{
\item{expr}{A numerical expression (for \code{around} and \code{between}) or an arbitrary expression (for \code{pos} and \code{layered}).
The objective are tuples where \code{expr} evaluates to a value in the preferred interval, layer, etc.
Regarding attributes, functions and variables, the same requirements as for \code{\link{base_pref}} apply.}

\item{center}{Preferred value for \code{around}.}

\item{left}{Lower limit of the preferred interval for \code{between}.}

\item{right}{Upper limit of the preferred interval for \code{between}.}

\item{pos_value}{A vector containing the preferred values for a \code{pos} preference.
Has to be of the same type (numeric, logical, character, ...) as \code{expr}.}

\item{...}{Layers (sets) for a \code{layered} preference. Each variable corresponds to one layer
           and the first set characterizes the most preferred values.}
}
\description{
In addition to the fundamental base preferences, rPref offers some macros to define preferences where a given interval or point is preferred.
}
\section{Definition of the preference macros}{


\describe{
  \item{\code{between(expr, left, right)}}{Those tuples are preferred where \code{expr} evaluates to a value between \code{left} and \code{right}.
  For values not in this interval the values nearest to the interval are preferred.}
  \item{\code{around(expr, center)}}{Same as \code{between(expr, center, center)}.}
  \item{\code{pos(expr, pos_value)}}{Those tuples are preferred, where \code{expr} evaluates to a value which is contained in \code{pos_value}.}
  \item{\code{layered(expr, layer1, layer2, ..., layerN)}}{For the most preferred tuples \code{expr} must evaluate to a value in \code{layer1}.
  The second-best tuples are those where \code{expr} evaluates to a value in \code{layer2} and so forth.
  Values occuring in none of the layers are considered worse than those in \code{layerN}.
  Technically, this is realized by a Prioritization (lexicographical order) chain of \code{\link{true}} preferences.}
}
}
\examples{
# Search for cars where mpg is near to 25
psel(mtcars, around(mpg, 25))

# cyl = 2 and cyl = 4 are equally good, cyl = 6 is worse
psel(mtcars, layered(cyl, c(2, 4), 6))
}

