% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formant.R
\name{formant.read}
\alias{formant.read}
\title{formant.read}
\usage{
formant.read(fileNameFormant, encoding = "UTF-8")
}
\arguments{
\item{fileNameFormant}{file name of Formant object}

\item{encoding}{File encoding (default: \code{"UTF-8"}), \code{"auto"} for auto-detect of Unicode encoding}
}
\value{
A Formant object represents formants as a function of time.

[ref: Praat help, http://www.fon.hum.uva.nl/praat/manual/Formant.html]

\code{f$xmin} ... start time (seconds)

\code{f$xmax} ... end time (seconds)

\code{f$nx}   ... number of frames

\code{f$dx}   ... time step = frame duration (seconds)

\code{f$x1}   ... time associated with the first frame (seconds)

\code{f$t}    ... vector of time instances associated with all frames

\code{f$maxnFormants} ... maximum number of formants in frame

\code{f$frame[[1]]} to \code{f$frame[[f$nx]]} ... frames

\code{f$frame[[1]]$intensity} ... intensity of the frame

\code{f$frame[[1]]$nFormants} ... actual number of formants in this frame

\code{f$frame[[1]]$frequency} ... vector of formant frequencies (in Hz)

\code{f$frame[[1]]$bandwidth} ... vector of formant bandwidths (in Hz)
}
\description{
Reads Formant object from Praat.
Supported formats: text file, short text file.
}
\examples{
\dontrun{
f <- formant.read('demo/maminka.Formant')
names(f)
f$nx
f$t[4]        # time instance of the 4th frame
f$frame[[4]]  # 4th frame: formants
f$frame[[4]]$frequency[2]
f$frame[[4]]$bandwidth[2]
}
}
\seealso{
\code{\link{pitch.read}}, \code{\link{pt.read}}, \code{\link{tg.read}}, \code{\link{it.read}}, \code{\link{col.read}}
}
