% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.removeIntervalRightBoundary}
\alias{tg.removeIntervalRightBoundary}
\title{tg.removeIntervalRightBoundary}
\usage{
tg.removeIntervalRightBoundary(tg, tierInd, index)
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{index}{index of the interval}
}
\value{
TextGrid object
}
\description{
Remove right boundary of the interval of the given index in Interval tier.
In fact, it concatenates two intervals into one (and their labels). It
cannot be applied to the last interval because it is the end boundary
of the tier.
E.g., we have interval 1-2-3, we remove the right boundary of the 2nd
interval, the result is two intervals 1-23.
If we do not want to concatenate labels, we have to set the label
to the empty string "" before this operation.
}
\examples{
\dontrun{
tg <- tg.sample()
tg.plot(tg)
tg2 <- tg.removeIntervalRightBoundary(tg, "word", 3)
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.removeIntervalLeftBoundary}}, \code{\link{tg.removeIntervalBothBoundaries}}, \code{\link{tg.insertBoundary}}, \code{\link{tg.insertInterval}}
}
