% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{it.legendre}
\alias{it.legendre}
\title{it.legendre}
\usage{
it.legendre(it, npoints = 1000, npolynomials = 4)
}
\arguments{
\item{it}{IntensityTier object}

\item{npoints}{Number of points of IntensityTier interpolation}

\item{npolynomials}{Number of polynomials to be used for Legendre modelling}
}
\value{
Vector of Legendre polynomials coefficients
}
\description{
Interpolate the IntensityTier in 'npoints' equidistant points and approximate it by Legendre polynomials
}
\examples{
it <- it.sample()
it <- it.cut(it, tStart = 0.2, tEnd = 0.4)  # cut IntensityTier and preserve time
c <- it.legendre(it)
print(c)
leg <- it.legendreSynth(c)
itLeg <- it
itLeg$t <- seq(itLeg$tmin, itLeg$tmax, length.out = length(leg))
itLeg$i <- leg
\dontrun{
plot(it$t, it$i, xlab = "Time (sec)", ylab = "Intensity (dB)")
lines(itLeg$t, itLeg$i, col = "blue")
}
}
\seealso{
\code{\link{it.legendreSynth}}, \code{\link{it.legendreDemo}}, \code{\link{it.cut}}, \code{\link{it.cut0}}, \code{\link{it.read}}, \code{\link{it.plot}}, \code{\link{it.interpolate}}
}
