% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.createNewTextGrid}
\alias{tg.createNewTextGrid}
\title{tg.createNewTextGrid}
\usage{
tg.createNewTextGrid(tMin, tMax)
}
\arguments{
\item{tMin}{Start time of TextGrid}

\item{tMax}{End time of TextGrid}
}
\value{
TextGrid object
}
\description{
Creates new and empty TextGrid. tStart and tEnd specify the total start
and end time for the TextGrid. If a new interval tier is added later
without specified start and end, they are set to TextGrid start and end.
}
\details{
This empty TextGrid cannot be used for almost anything. At least one tier
should be inserted using tg.insertNewIntervalTier() or tg.insertNewPointTier().
}
\examples{
tg <- tg.createNewTextGrid(0, 5)
tg <- tg.insertNewIntervalTier(tg, 1, "word")
tg <- tg.insertInterval(tg, "word", 1, 2, "hello")
tg.plot(tg)
}
\seealso{
\code{\link{tg.insertNewIntervalTier}}, \code{\link{tg.insertNewPointTier}}
}
