% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_json_query.R
\name{generate_json_query}
\alias{generate_json_query}
\title{Generate a JSON Query for RCSB PDB Data Retrieval}
\usage{
generate_json_query(ids, data_type, properties)
}
\arguments{
\item{ids}{A vector of identifiers for which data needs to be retrieved.}

\item{data_type}{A string indicating the type of data to be queried, such as 'ENTRY', 'POLYMER_ENTITY', etc.}

\item{properties}{A list of properties to be included in the query. Each element of the list should be
a character vector representing properties for the respective data type.}
}
\value{
A string representing the generated JSON query formatted for PDB data retrieval.
}
\description{
This function constructs a JSON query for retrieving data from the RCSB Protein Data Bank (PDB).
It requires input parameters like IDs, data type, and properties to tailor the query for specific data retrieval needs.
}
\examples{
ids <- c("1XYZ", "2XYZ")
properties <- list(cell = c("volume", "angle_beta"), exptl = c("method"))
json_query <- generate_json_query(ids, "ENTRY", properties)
json_query
}
