% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.K.VanRaden.r
\name{MVP.K.VanRaden}
\alias{MVP.K.VanRaden}
\title{Calculate Kinship matrix by VanRaden method}
\usage{
MVP.K.VanRaden(
  M,
  maxLine = 5000,
  ind_idx = NULL,
  mrk_idx = NULL,
  mrk_freq = NULL,
  mrk_bycol = TRUE,
  cpu = 1,
  verbose = TRUE,
  checkNA = TRUE
)
}
\arguments{
\item{M}{genotype, either m by n or n by m is supportable, m is marker size, n is population size}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{ind_idx}{the index of effective genotyped individuals used in analysis}

\item{mrk_idx}{the index of effective markers used in analysis}

\item{mrk_freq}{the prior calculated major allele frequency (not MAF) for all markers used in analysis}

\item{mrk_bycol}{whether the markers are stored by columns in genotype (i.e. M is a n by m matrix)}

\item{cpu}{the number of cpu}

\item{verbose}{whether to print detail.}

\item{checkNA}{whether to check NA in genotype.}
}
\value{
K, n * n matrix
}
\description{
Calculate Kinship matrix by VanRaden method
}
\examples{
\donttest{
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

K <- MVP.K.VanRaden(genotype, cpu=1)
}

}
